# coding=utf-8
from sandbox.projects.sandbox_ci.utils.github import convert_sandbox_status_to_github_state
from sandbox.projects.sandbox_ci.utils.arcanum import convert_sandbox_status_to_arcanum_status


class SourceCodeProviderFeedback(object):
    def __init__(self, task):
        """
        :param task:
        :type task: sandbox.projects.sandbox_ci.task.BaseTask
        """
        self.task = task
        self._set_reporter()

    def _set_reporter(self):
        # TODO FEI-16663
        # Логику определения scp лучше определять по комбинации факторов genesys + параметры задачи
        # на данный момент пока статусы в Арканум не будут идти на прод, можно оставить по умолчанию GitHub
        self._reporter = self.task.github_statuses
        self.reporter_type = 'github'

        if self.task.Parameters.arcanum_review_request_id and self.task.Parameters.arcanum_diff_set_id:
            self._reporter = self.task.arcanum_checks
            self.reporter_type = 'arcanum'

    def convert_task_status_to_scp_state(self, task_status):
        if self.reporter_type == 'github':
            return convert_sandbox_status_to_github_state(task_status)

        return convert_sandbox_status_to_arcanum_status(task_status)

    def get_report_statuses_parameter(self):
        if self.reporter_type == 'github':
            return self.task.Parameters.report_github_statuses

        return self.task.Parameters.report_arcanum_checks

    @property
    def report_statuses_config(self):
        """
        :rtype: bool
        """
        return self.task.project_conf.get(self.reporter_type, {}).get('report_statuses', False)

    @property
    def should_report_statuses(self):
        """
        По параметрам таски и конфигу вычисляет, должна ли она репортить статус.
        :rtype: bool
        """
        return self._reporter.should_report_statuses

    def report_self_status(self, *args, **kwargs):
        self._reporter.report_self_status(*args, **kwargs)

    def safe_report_self_status(self, *args, **kwargs):
        self._reporter.safe_report_self_status(*args, **kwargs)

    def safe_report_status(self, *args, **kwargs):
        self._reporter.safe_report_status(*args, **kwargs)

    def report_status_to_current_sha(self, *args, **kwargs):
        self._reporter.report_status_to_current_sha(*args, **kwargs)
