import os
import logging
import shutil

from sandbox import sdk2


class TemplateErrorCollectorManager(object):
    def __init__(self, task):
        self.task = task

    def __get_template_error_collector_plugin(self):
        from sandbox.projects.sandbox_ci.task.test_task.plugins import TemplateErrorCollector
        
        plugin = TemplateErrorCollector(self.task)
        plugin.set_env()
        
        return plugin

    def __load_template_errors_reports(self, task_ids, report_type):
        return filter(bool, map(lambda task_id: sdk2.Resource.find(task_id=task_id, attrs={'type': report_type}).first(), task_ids))

    def __merge_template_errors(self, resources, report_file_name):
        report_file_path = self.task.project_path(report_file_name)
        merged_report_abs_path = str(self.task.working_path(report_file_path))

        with open(merged_report_abs_path, 'w') as dest:
            for resource in resources:
                resource_path = str(sdk2.ResourceData(resource).path)
                
                dest.write('template-errors.txt from task {}:\n\n'.format(resource.task_id))
                
                with open(resource_path, 'r') as src:
                    shutil.copyfileobj(src, dest)

                dest.write('\n\n')

    def publish_merged_template_errors(self, subtask_ids, status, attrs):
        try:
            plugin = self.__get_template_error_collector_plugin()

            resources = self.__load_template_errors_reports(subtask_ids, plugin.report_type)
            if not len(resources):
                return
            
            self.__merge_template_errors(resources, plugin.report_file_name)

            plugin.make_reports(status, attrs)

        except Exception as e:
            logging.error('Cannot merge template errors: %s', str(e))
