import logging

from sandbox.projects.sandbox_ci.utils.request import send_request

ZEROLINE_BASE_URL = 'https://zeroline.si.yandex.net/api/v1/report-task-status'


class ZerolineReporter(object):
    def _send(self, data):
        """
        Sends data to zeroline.

        :param data: data
        :type data: dict | list of dict
        """
        logging.debug('Sending data to zeroline: {}'.format(data))

        return send_request(
            method='post',
            url=ZEROLINE_BASE_URL,
            headers={
                'Content-Type': 'application/json',
            },
            json=data,
            timeout=60,
        )

    def report_task(self, details):
        """
        Sends data to zeroline report handler for analyzing

        :param details: Task status(s) dict.
        :type details: dict | list of dict
        """
        self._send(details)
