# -*- coding: utf-8 -*-
import json

from sandbox import sdk2

from sandbox.projects.sandbox_ci.resources import SANDBOX_CI_LXC_IMAGE, SANDBOX_CI_ARTIFACT, SandboxCiScripts


# TODO: Remove when sdk2 will support reading
# of common parameters specified in any place (@see SANDBOX-3971)
class CommonParameters(sdk2.Parameters):
    dump_disk_usage = False
    kill_timeout = 1 * 3600  # 1 hour


class CommitHash(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        value = super(CommitHash, cls).cast(value)
        if not cls.required and not value:
            return value
        if not len(value) == 40:
            raise ValueError('Commit must be a 40 character SHA1')
        return value


class JSONString(sdk2.parameters.String):
    multiline = True

    @classmethod
    def cast(cls, value):
        value = super(JSONString, cls).cast(value)
        if not cls.required and not value:
            return value
        try:
            json.loads(value)
        except ValueError as msg:
            raise ValueError('Invalid JSON: {}'.format(msg))
        return value


class EnumString(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        assert value in list(k for k, v in cls.choices)
        return value


project_github_owner = sdk2.parameters.String(
    'GitHub owner',
    description='Логин владельца репозитория или название организации',
)

project_github_repo = sdk2.parameters.String(
    'GitHub repo',
    description='Название репозитория',
)


class ProjectGitHubRepositoryParameters(sdk2.Parameters):
    with sdk2.parameters.Group('GitHub репозиторий проекта') as github_repo_block:
        project_github_owner = project_github_owner()
        project_github_repo = project_github_repo()


scripts_archive_url = sdk2.parameters.String(
    'Scripts archive url',
    required=True,
    description='Ссылка на архив (tar.gz) скриптов',
    default='https://github.yandex-team.ru/search-interfaces/ci/archive/master.tar.gz',
)


class ScriptsSourcesParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Скрипты для sandbox-задачи') as scripts_sources_block:
        scripts_last_resource = sdk2.parameters.Bool(
            'Download last build resource',
            default=True,
            description='Скачать последний ресурс собранный из master',
            sub_fields=dict(false=('scripts_resource',)),
        )
        scripts_resource = sdk2.parameters.LastReleasedResource(
            'CI Scripts resource',
            required=True,
            description='Ресурс с архивом ci скриптов',
            resource_type=SandboxCiScripts,
            attrs=dict(branch='master'),
        )


project_git_url = sdk2.parameters.String('Project git url')

project_git_base_ref = sdk2.parameters.String(
    'Project git base ref',
    default='master',
)

project_git_base_commit = CommitHash('Project git base commit')

project_git_merge_ref = sdk2.parameters.List('Project git merge ref')
project_merge_refs = sdk2.parameters.List('Project merge refs')
refs_to_merge = sdk2.parameters.JSON('Refs to merge')

project_git_head_ref = sdk2.parameters.String('Project git head ref')

project_current_branch = sdk2.parameters.String('Project current branch')

project_git_head_commit = CommitHash('Project git head commit')

project_git_merge_commit = CommitHash('Project git merge commit')

stop_outdated_tasks = sdk2.parameters.Bool('Stop outdated tasks for the same git ref', default=False)

project_build_context = sdk2.parameters.String(
    'Genisys configuration section',
)

notify_subtask_statuses = sdk2.parameters.Bool(
    'Send notification about subtask statuses',
    description='Отправлять уведомления о статусе подзадач',
    default=True,
)

build_platform = sdk2.parameters.String(
    'Build platform (all if not specified)',
    default='',
)

selective_checks = sdk2.parameters.Bool(
    'Run selective checks based on code changes',
    default=True,
)

skip_lfs_checkout = sdk2.parameters.Bool(
    'Skip lfs checkout',
    default=False,
)

project_tree_hash = CommitHash('Project tree hash')

project_base_hash = CommitHash('Source base commit hash')

project_hash = CommitHash('Project commit hash')

reuse_dependencies_cache = sdk2.parameters.Bool(
    'Reuse dependencies cache (libs, node_modules, etc)',
    default=True,
)

reuse_artifacts_cache = sdk2.parameters.Bool(
    'Reuse artifacts cache',
    default=True,
)

reuse_subtasks_cache = sdk2.parameters.Bool(
    'Reuse subtasks cache',
    default=True,
)

reuse_task_cache = sdk2.parameters.Bool(
    'Reuse task cache',
    default=False,
)

build_artifacts_resources = sdk2.parameters.Resource(
    'Build artifacts',
    resource_type=SANDBOX_CI_ARTIFACT,
    multiple=True,
    required=True,
)

selenium_browsers = sdk2.parameters.List('Selenium browsers')

with sdk2.parameters.String('Platform', required=True) as platform:
    platform.values[''] = platform.Value('---', default=True)
    platform.values['desktop'] = 'desktop'
    platform.values['touch-pad'] = 'touch-pad'
    platform.values['touch-phone'] = 'touch-phone'

project_github_commit = CommitHash('Hash of commit for reporting status into GitHub')
report_github_statuses = sdk2.parameters.Bool('Report GitHub statuses', default=True)


class GithubStatusParameters(sdk2.Parameters):
    with sdk2.parameters.Group('GitHub status') as github_status_block:
        report_github_statuses = report_github_statuses()
        project_github_commit = project_github_commit()


report_arcanum_checks = sdk2.parameters.Bool(
    'Отправлять ли информацию о статусе в Arcanum',
    default=False
)
arcanum_review_request_id = sdk2.parameters.Integer(
    'Arcanum review request id',
)
arcanum_diff_set_id = sdk2.parameters.Integer(
    'Diff set ID для выбранного review request',
)


class ArcanumChecksParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Arcanum') as arcanum_block:
        report_arcanum_checks = report_arcanum_checks()
        arcanum_review_request_id = arcanum_review_request_id()
        arcanum_diff_set_id = arcanum_diff_set_id()


path_in_arcadia = sdk2.parameters.String(
    'Директория проекта в Аркадии',
    default='frontend/projects/web4'
)


class ArcadiaParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Arcadia parameters') as arcadia_block:
        path_in_arcadia = path_in_arcadia()


environment_container = sdk2.parameters.Container(
    'Ресурс с LXC-контейнером окружения',
    # see https://st.yandex-team.ru/FEI-5047
    resource_type=(SANDBOX_CI_LXC_IMAGE,),
    platform='linux_ubuntu_18.04_bionic',  # necessary for correct default resource searching
    required=False,
)


environment_variables = sdk2.parameters.Dict('Environment variables')


class EnvironmentParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Environment') as environ_block:
        environ = environment_variables()
        _container = environment_container()


wait_tasks = sdk2.parameters.List('Tasks to wait', sdk2.parameters.Integer)
wait_output_parameters = sdk2.parameters.Dict(
    'Ожидать output-параметры задач',
    description='Параметр указывается в формате словаря: ключ — id задачи (первая колонка), значение (вторая колонка) — название output-параметров задачи через запятую',
)


class DependenceParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Dependencies') as deps_block:
        wait_tasks = wait_tasks()
        wait_output_parameters = wait_output_parameters()


pulse_tests = sdk2.parameters.Bool(
    'Run pulse tests',
    default=True,
)

pulse_should_report_to_stat = sdk2.parameters.Bool(
    'Report pulse metrics to statface',
    default=False,
)

pulse_should_run_ticount = sdk2.parameters.Bool(
    'Run ticount',
    default=False,
)


class DebuggingParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Debugging') as debugging_logs:
        logging_paths = sdk2.parameters.Dict('Paths to save (path in task -> path rel to TASK_LOGS)')

        overwrite_client_tags_flag = sdk2.parameters.Bool("Overwrite client tags", default=False)
        # allow to tune hosts scope to run the task based on client tags https://nda.ya.ru/3RhRAc
        with overwrite_client_tags_flag.value[True]:
            overwritten_client_tags = sdk2.parameters.ClientTags("Client tags")


beta_suffix = sdk2.parameters.String(
    'Beta suffix',
    required=True,
    description='Суффикс для деплоя беты, станет частью домена.',
    default='',
)

keep_beta_forever = sdk2.parameters.Bool(
    'Keep beta forever',
    description='Не удалять бету в Yappy по TTL',
    default=False,
)

do_find_dev_beta_slot = sdk2.parameters.Bool(
    'Find deploy slot of dev-branch beta',
    description='Найти слот, занимаемый бетой для dev',
    default=False,
)

overwrite_quota = sdk2.parameters.String(
    'Overwrite quota for beta',
    description='Заменить квоту по умолчанию на указанную',
    default='',
)

deploy_webhook_urls = sdk2.parameters.List(
    'Список вебхуков для задачи деплоя',
    description=u'После создания беты нужно сообщить внешним потребителям о том, какой слот она заняла – укажите список URL-ов таких сервисов.',
    value_type=sdk2.parameters.Url,
    default=[],
)

gemini_platforms = sdk2.parameters.List(
    'Gemini platforms', required=True,
    default=('desktop', 'touch-pad', 'touch-phone'),
)

molly_platforms = sdk2.parameters.List(
    'Molly platforms',
    required=True,
    description='Список существующих платформ. Параметры запуска для каждой платформы находятся в Genisys',
    default=('desktop', 'touch-pad', 'touch-phone'),
)

hermione_platforms = sdk2.parameters.List(
    'Hermione platforms', required=True,
    default=('desktop', 'touch-pad', 'touch-phone'),
)

pulse_platforms = sdk2.parameters.List(
    'Pulse platforms', required=True,
    default=('desktop', 'touch'),
)


class DeployYappyParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Yappy Deploy') as yappy_beta_block:
        keep_beta_forever = keep_beta_forever()
        beta_suffix = beta_suffix()
        deploy_webhook_urls = deploy_webhook_urls()
        do_find_dev_beta_slot = do_find_dev_beta_slot()
        overwrite_quota = overwrite_quota()


class StatfaceParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Statface') as statface_opts:
        statface_host = sdk2.parameters.String('Statface host', required=True, default='upload.stat.yandex-team.ru')
        send_statistic = sdk2.parameters.Bool('Отправлять статистику', default=True)


coredump_filter_pattern = sdk2.parameters.String(
    'coredump filter pattern',
    description='Регулярное выражение, по которому отфильтруют имена кордампов',
)

force_manual_test_runs = sdk2.parameters.Bool(
    u'Принудительно создавать задачу manual-test-runs'
)


class ManualTestRunsParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Manual test runs') as manual_test_runs_block:
        force_manual_test_runs = force_manual_test_runs()


class AssessorsParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Assessors') as assessors_block:
        ab_experiments_title = sdk2.parameters.String(
            'Заголовок для эксперимента с шаблонами',
            description='Заголовок нужен для того, чтобы отличить один эксперимент от другого.',
        )
        ab_experiments_webhook_urls = sdk2.parameters.List(
            'Список вебхуков',
            description=u'После подготовки тестирования на асессорах можно передать собранные знания в другие сервисы – укажите список URL-ов таких сервисов.',
            value_type=sdk2.parameters.Url,
        )
        ab_experiments_config_path = sdk2.parameters.String(
            'Путь до файла конфигурации заведения test-id для пулл-реквеста',
            description='Путь до конфига в репозитории, на основе которого происходит шаблонизация создаваемых test-id для пулл-реквестов.',
        )
        assessors_config_path = sdk2.parameters.String(
            'Путь до файла конфигурации запусков тест-сьютов на асессоров/толокеров',
            description=u'Путь до конфига в репозитории, на основе которого происходит запуск тестирования на асессорах. Если путь не указан – запуска не будет.',
        )
        testids_for_flags = sdk2.parameters.Bool(
            'Запуск testid для каждого флага',
            description=u'Запускать создание testid для новых флагов.',
            default=False,
            sub_fields={
                'true': ['testpalm_project_name'],
            },
        )
        testpalm_project_name = sdk2.parameters.String(
            'Имя проекта в TestPalm для пулл-реквеста',
            description=u'Из этого проекта будут выгружаться флаги в пулл-реквесте.',
        )
        testpalm_base_project_name = sdk2.parameters.String(
            'Имя проекта в TestPalm для dev',
            description=u'По этому проекту будет производиться поиск кэша с testid.',
        )
        force_assessors_run = sdk2.parameters.Bool(
            'Принудительно запускать раздачу',
            default=False,
            description='Если релиз уже был и раздача на асессоров прошла успешно, при перезапауске релиза раздача происходить не будет.'
                        'Укажите этот флаг, если всё равно хотите запустить раздачу.',
        )


send_comment_to_issue = sdk2.parameters.String(
    'Issue key',
    description='Таск по завершении пишет в тикет комментарий.',
)

send_comment_to_searel = sdk2.parameters.Bool(
    'Send comment to issue',
    description='Если флаг выставлен в True, то в релевантную SEAREL задачу отправляем комментарий со статусом. '
                'Находится в Трекере по заголовку <owner>/<repo>@<version>, версия извлекается из имени ветки: '
                'release/<version> или release/<subproject>/<version>.',
    default=False,
)


class TrackerParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Tracker') as tracker_block:
        send_comment_to_searel = send_comment_to_searel()

data_center = sdk2.parameters.String(
    'Дата центр, в котором будут запущены тесты',
    choices=[
        ('RANDOM', 'RANDOM'),
        ('IVA', 'IVA'),
        ('SAS', 'SAS'),
        ('MYT', 'MYT'),
        ('VLA', 'VLA'),
        ('MAN', 'MAN'),
        ('UNK', 'UNK'),
    ],
    default='RANDOM',
)


class NodeJsParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Node js') as node_js_block:
        node_js_version = sdk2.parameters.String(
            'Версия node js',
            description='Позволяет переопределить версию, которая выставлена в LXC-контейнере по умолчанию',
        )

pull_request_merge_provider = sdk2.parameters.String(
    'Провайдер влития ревью-реквестов Арканума',
    default='github',
    choices=[
        ('GitHub (PR → GitHub PR → git → svn → arc)', 'github'),
        ('Arcanum (PR → svn → arc)', 'arcanum'),
    ],
    description='Определяет способ, с помощью которого пулл-реквесты будут влиты в arc. '
                'Провайдер `arcanum` вольёт ревью-реквест с помощью Arcanum (в trunk svn, с синхронизацией в trunk arc). '
                'Провайдер `github` создаст анологичные пулл-реквесты в GitHub, пулл-реквесты из GitHub будут влиты в основную ветвь git-репозитория, '
                'git-коммиты будут синхронизированы из git в trunk svn, а затем и в trunk arc.',
)
