# coding=utf-8
VELOCITY_EMAIL = 'serp-velocity-monitoring@yandex-team.ru'
FIJI_VELOCITY_EMAIL = 'mm-interfaces-velocity@yandex-team.ru'

WEB_EXP_NAMES = ('web_exp', 'web3_exp', 'web_exp3', 'web_exp4')

AMMO_TYPE_BASE = 'base'
AMMO_TYPE_ACTUAL = 'actual'

PULSE_BINARY_SHOOTER = 'pulse-shooter'
PULSE_BINARY_STATIC = 'pulse-static'
PULSE_BINARY_AGGREGATOR = 'pulse-aggregator'
PULSE_BINARY_REPORT = 'pulse-report'
PULSE_BINARY_MEMORY_LEAKS_DETECTOR = 'pulse-memory-leaks-detector'
PULSE_BINARY_HTML_DIFFER = 'pulse-html-differ'
PULSE_BINARY_DIFF_VIEWER = 'pulse-diff-viewer'
PULSE_BINARY_BLOCKSTAT_LOG_ANALYZER = 'pulse-blockstat-log-analyzer'

# Реестр проектов, в которых обслуживается Пульс
# Используется в задачах, когда надо пересобрать компоненты для всех проектов
PROJECTS_PLATFORMS_WITH_PULSE = {
    'web4': [
        'desktop',
        'touch',
    ],
    'fiji': [
        'images-desktop',
        'images-touch-phone',
        'images-touch-pad',
        'video-desktop',
        'video-touch-phone',
        'video-touch-pad',
    ],
    'granny': [
        'desktop',
        'touch',
    ],
    'turbo': [
        'desktop',
        'touch',
        'touch-saas-features',
        'desktop-publishers',
        'touch-landings',
        'touch-news-story',
        'touch-publishers',
        'touch-weather',
    ],
    'news': [
        'desktop',
        'touch',
        'main-desktop',
        'main-touch',

        'rubric-desktop',
        'rubric-touch',

        'story-desktop',
        'story-touch',
    ],
    'ydo': [
        'touch',
        'desktop'
    ]
}

HANDLERS_MAP = {
    'web4': {
        'desktop': '/search/',
        'touch-pad': '/search/pad/',
        'touch': '/search/touch/',
    },
    'granny': {
        'desktop': '/search/',
        'touch': '/search/touch/',
    },
    'fiji': {
        'images-desktop': '/images/',
        'images-touch-pad': '/images/pad/',
        'images-touch-phone': '/images/touch/',
        'video-desktop': '/video/',
        'video-touch-phone': '/video/touch/',
        'video-touch-pad': '/video/pad/',
    },
    'turbo': {
        'desktop': '/turbo',
        'touch': '/turbo',
        'touch-saas-features': '/turbo',
        'desktop-publishers': '/turbo',
        'touch-landings': '/turbo',
        'touch-news-story': '/turbo',
        'touch-publishers': '/turbo',
        'touch-weather': '/turbo',
    },
    'news': {
        'desktop': '/news',
        'touch': '/news',
        'main-desktop': '/news',
        'main-touch': '/news',

        'rubric-desktop': '/news/rubric',
        'rubric-touch': '/news/rubric',

        'story-desktop': '/news/story',
        'story-touch': '/news/story',
    },
    'ydo': {
        'desktop': '/uslugi',
        'touch': '/uslugi',
    }
}

for _web_exp_name in WEB_EXP_NAMES:
    HANDLERS_MAP[_web_exp_name] = HANDLERS_MAP['web4']

ROUTES_CONFIG = {
    'web4': {
        'desktop': 'web4:desktop',
        'touch': 'web4:phone',
        'touch-pad': 'web4:pad',
        '_config': {
            'has_pre_search': True,
            'touch': {
                'expected_shots_count': 3
            },
            'desktop': {
                'expected_shots_count': 3
            }
        },
    },
    'granny': {
        'desktop': 'granny:desktop',
        'touch': 'granny_exp:phone',
        '_config': {'has_pre_search': True},
    },
    'fiji': {
        'images-desktop': 'images3:desktop',
        'images-touch-phone': 'images3:phone',
        'images-touch-pad': 'images3:pad',
        'video-desktop': 'video3:desktop',
        'video-touch-phone': 'video3:phone',
        'video-touch-pad': 'video3:pad',
        '_config': {'has_pre_search': True},
    },
    'news': {
        'desktop': 'neo-story.desktop',
        'touch': 'neo-story.touch-phone',
        'main-desktop': 'neo-rubrics.desktop',
        'main-touch': 'neo-rubrics.touch-phone',

        'rubric-desktop': 'neo-rubrics.desktop',
        'rubric-touch': 'neo-rubrics.touch-phone',

        'story-desktop': 'neo-story.desktop',
        'story-touch': 'neo-story.touch-phone',
        '_config': {'has_pre_search': False},
    },
    'turbo': {
        'desktop': 'turbo:desktop',
        'touch': 'turbo:phone',
        'touch-saas-features': 'turbo:phone',
        'touch-landings': 'turbo:phone',
        'touch-news-story': 'turbo:phone',
        'touch-publishers': 'turbo:phone',
        'touch-weather': 'turbo:phone',
        'desktop-publishers': 'turbo:desktop',
        '_config': {'has_pre_search': True},
    },
    'ydo': {
        'desktop': 'ydo:desktop',
        'touch': 'ydo:desktop',
        '_config': {'has_pre_search': False},
    }
}

for _web_exp_name in WEB_EXP_NAMES:
    ROUTES_CONFIG[_web_exp_name] = {
        'desktop': _web_exp_name + ':desktop',
        'touch': _web_exp_name + ':phone',
        'touch-pad': _web_exp_name + ':pad',
        '_config': {'has_pre_search': True},
    }

HAMSTER_QUERY_PARAMS = {
    'no-tests': 1,
    'exp_flags': 'test_tool=pulse',
}

HAMSTER_QUERY_PARAM_LIST = ['%s=%s' % (k, v) for k, v in HAMSTER_QUERY_PARAMS.iteritems()]

CLASSIC_PARAMS = {
    'web4': {},
    'granny': {},
    'fiji': {},
    'turbo': {},
}

for _web_exp_name in WEB_EXP_NAMES:
    CLASSIC_PARAMS[_web_exp_name] = CLASSIC_PARAMS['web4']

APPHOST_PARAMS = {
    'web4': {
        'query_params': {
            'app_host_srcskip': 'POST_SEARCH_TEMPLATE_DATA=0,PRE_SEARCH_TEMPLATE_DATA=0',
            'init_meta': 'use-app-host-templates',
        },
    },
    'turbo': {
        'endpoint_suffix': '/adapter',
    },
    'news': {
        'query_params': {
            'apphost_mode': 'true',
            'init_meta': 'use-app-host-templates',
            'flags': 'yxnews_core_render_with_neo_desktop=1;yxnews_core_actions_with_neo=index,rubric,story',
        }
    },
    'ydo': {},
}
APPHOST_PARAMS['granny'] = APPHOST_PARAMS['web4']

for _web_exp_name in WEB_EXP_NAMES:
    APPHOST_PARAMS[_web_exp_name] = APPHOST_PARAMS['web4']

PROJECTS_WITH_HTML_DIFFER_FILTRATION_SUPPORT = (
    'web4',
)

PULSE_STAT_LINKS = {
    'web4-desktop': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=jd&state=c9438df5842',
    'web4-touch-pad': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=jd&state=15114e8f878',
    'web4-touch': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=jd&state=4aec2577806',
    'fiji-images-desktop': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=c2c8f9371760',
    'fiji-images-touch-pad': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=a20bd15b1796',
    'fiji-images-touch-phone': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=357d6a3f1832',
    'fiji-video-desktop': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=277e351a1742',
    'fiji-video-touch-pad': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=724c50ab1778',
    'fiji-video-touch-phone': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=rXe&state=075dd5eb1814',
    'turbo-desktop': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=20e&state=13ad5a5b2504',
    'turbo-touch': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=20e&state=42adc20a2474',
    'turbo-touch-saas-features': 'https://datalens.yandex-team.ru/rru7sc0fo1ykm-pulseweb4report?tab=20e&state=29bb60332684',
}

PULSE_WIKI_LINKS = {
    'pulse_shooter': 'https://wiki.yandex-team.ru/velocity/serp/pulse/',
    'two_shooting_baskets': 'https://wiki.yandex-team.ru/velocity/serp/pulse/pulse-shooter-abt/',
    'memory_leaks': 'https://wiki.yandex-team.ru/velocity/serp/pulse/memory-leaks/',
}
