from collections import OrderedDict
from operator import itemgetter

MIN_WEIGHT = 0.001


def measure_weights(wiz_data, template_weight=70, size_weight=30):
    sum_template = 0
    sum_size = 0

    transformed_data = {}

    for wiz_id, cur_wiz_data in wiz_data.iteritems():
        total_template = min(cur_wiz_data['total_template_time'], 0) * -1
        gzipped_size = min(cur_wiz_data['gzipped_size'], 0) * -1

        sum_template += total_template
        sum_size += gzipped_size

        transformed_data[wiz_id] = (total_template, gzipped_size)

    weights = []
    for wiz_id, cur_wiz_data in transformed_data.iteritems():
        total_template, gzipped_size = cur_wiz_data

        template_percent = total_template * 100.0 / sum_template
        size_percent = gzipped_size * 100.0 / sum_size

        weight = (template_weight * template_percent + size_weight * size_percent) / (template_weight + size_weight)
        if weight < MIN_WEIGHT:
            weight = MIN_WEIGHT
        weights.append((wiz_id, weight))

    weights.sort(key=itemgetter(1), reverse=True)
    return OrderedDict(weights)


def draw_diagram(weights):
    res = []
    for wiz_id, weight in weights.iteritems():
        cnt = int(round(weight))
        res.append(wiz_id + '\t' + ('#' * cnt))
    return '\n'.join(res)
