USE hahn;

PRAGMA yt.Pool = 'velocity';

INSERT INTO
    `home/trencher/tmp/pulse/measure-wizard-weights/$task_hash/dataset` WITH TRUNCATE
SELECT
    acc.request AS path,
    acc.headers AS headers,
    req.ids AS ids
FROM
    RANGE(`logs/yandex-access-log/1d`, `$date_from`, `$date_to`) AS acc
INNER JOIN (
    SELECT DISTINCT
        requestId
    FROM
        RANGE(`logs/renderer-request-event-log/1d`, `$date_from`, `$date_to`)
    WHERE
        path == '$routes_id'
) AS prof
ON acc.req_id == prof.requestId
INNER JOIN (
    SELECT
        RequestId,
        ListMap(SearchPropsUPPER.ApplyBlender.IntentPos, ($x) -> { RETURN Unwrap($x.key, "") }) AS ids
    FROM
        RANGE(`logs/search-proto-reqans-log/1d`, `$date_from`, `$date_to`)
    WHERE
        RequestId IS NOT NULL
        AND SearchPropsUPPER.ApplyBlender.IntentPos IS NOT NULL
) AS req
ON acc.req_id == req.RequestId
WHERE
    acc.req_id IS NOT NULL
    AND acc.req_id != '-'
    AND String::Contains(acc.request, '$request_pattern')
    AND acc.x_yandex_internal_request == '0'
    AND acc.x_yandex_suspected_robot == '0'
ORDER BY
    RANDOM(path)
;

COMMIT;

INSERT INTO
    `home/trencher/tmp/pulse/measure-wizard-weights/$task_hash/ids` WITH TRUNCATE
SELECT
    id,
    cnt
FROM (
    SELECT
        id,
        COUNT(*) AS cnt
    FROM
        `home/trencher/tmp/pulse/measure-wizard-weights/$task_hash/dataset`
    FLATTEN LIST BY ids AS id
    GROUP BY id
)
WHERE
    cnt > $show_limit
ORDER BY
    cnt DESC
;
