#  -*- coding: utf-8 -*-
from sandbox.common.types import notification as ctn

PULSE_MON_EMAIL = 'pulse-mon@yandex-team.ru'
DEFAULT_NOTIFY_TO = 'pulse-mon'
DEFAULT_NOTIFY_TO_EMAIL = '{}@yandex-team.ru'.format(DEFAULT_NOTIFY_TO)
DEFAULT_NOTIFY_FIJI_TO_EMAIL = '{}@yandex-team.ru'.format('fijipulse-bug')


def notify_template_error(master_task, context, label):
    """
    :param master_task: Инстанс мастертаски SANDBOX_CI_<PROJECT_NAME>
    :type master_task: sandbox.projects.sandbox_ci.task.BaseBuildTask.BaseBuildTask
    :param context: Контекст github статуса
    :type context: str
    """
    master_task.meta.skip_step(
        label=label,
        reason='error',
        github_context=context,
        description=u'Не удалось найти шаблоны. → infraduty@.'
    )


def send_pulse_email(master_task, email, title, text):
    """
    :type master_task: sandbox.projects.sandbox_ci.task.BaseBuildTask.BaseBuildTask
    :type email: str or String
    :type title: str or String
    :type text: str or String
    """

    master_task.server.notification(
        subject=title,
        body=text,
        recipients=[email],
        transport=ctn.Transport.EMAIL,
        charset=ctn.Charset.UTF,
        type=ctn.Type.HTML,
    )
