# -*- coding: utf-8 -*-
from datetime import datetime, timedelta

from sandbox import sdk2
from sandbox.projects.sandbox_ci.pulse import const as pulse_const

now = datetime.now()
DEFAULT_DATE = (now - timedelta(days=1)).strftime('%Y-%m-%d')

platform = sdk2.parameters.String(
    'Platform to profile(desktop, touch)',
    default='desktop',
    required=True,
)

requests_limit = sdk2.parameters.Integer(
    'Requests limit',
    default=25000,
    required=True,
)

base_flags = sdk2.parameters.Dict('Additional request data flags for shooting base templates')
actual_flags = sdk2.parameters.Dict('Additional request data flags for shooting actual templates')

should_report_to_stat = sdk2.parameters.Bool(
    'Report pulse metrics to statface',
    default=False
)

fail_on_limits_exceed = sdk2.parameters.Bool(
    'Fail task on limits exceed',
    default=True
)

send_email_on_limits_exceed = sdk2.parameters.Bool(
    'Send email on limits exceed',
    default=False
)

check_static_files = sdk2.parameters.Bool(
    'Check static files',
    default=False,
    description='Проверять наличие файлов статики'
)

project = sdk2.parameters.String('Project', default='web4')

with sdk2.parameters.String(
    'SoY operation priority',
    description='Priority of SoY operation for Pulse Shooter ammo building'
) as soy_operation_priority:
    soy_operation_priority.values['low'] = soy_operation_priority.Value('low', default=True)
    soy_operation_priority.values['normal'] = soy_operation_priority.Value('normal')
    soy_operation_priority.values['high'] = soy_operation_priority.Value('high')

with sdk2.parameters.RadioGroup('Target', required=True) as shooting_basket_target:
    for _project, _platforms in pulse_const.PROJECTS_PLATFORMS_WITH_PULSE.iteritems():
        for _platform in _platforms:
            target_name = '{}:{}'.format(_project, _platform)
            shooting_basket_target.values[target_name] = shooting_basket_target.Value(value=target_name)
