import os

from sandbox.projects.sandbox_ci.pulse.yql_query_builder import YQLQueryBuilder

# use_batch: value
YQL_QUERY_MAP = {
    False: 'soy_source.sql',
    True: 'soy_source_batched.sql',
}


def build_soy_table_query(
    input_table,
    output_table,
    use_batch=False,
    report_host='hamster.yandex.ru',
    base_query_params=[],
    actual_query_params=[],
):
    query_builder = YQLQueryBuilder(tasks_path=os.path.dirname(__file__))

    filename = YQL_QUERY_MAP.get(use_batch)

    return query_builder.build_from_file(
        filename=filename,
        input_table=input_table,
        output_table=output_table,
        report_host=report_host,
        base_query_params_list=__prepare_params(base_query_params),
        actual_query_params_list=__prepare_params(actual_query_params),
    )


def __prepare_params(params):
    return str([param.encode('utf-8', 'ignore') for param in params])
