USE hahn;

PRAGMA yt.Pool = 'velocity';
PRAGMA yt.UseNativeYtTypes;

$common_query_params = [
    'init_meta=use-app-host-templates',
    'reqinfo=abc:velocityandstability:pulse:0',
    'app_host_srcskip=POST_SEARCH_TEMPLATE_DATA=0,PRE_SEARCH_TEMPLATE_DATA=0',
    'renderer_export=binary'
];

$base_query_params = ListExtend($common_query_params, $base_query_params_list);

$headers_to_delete = [
    'accept-encoding',
    'x-req-id',
    'content-encoding',
    'x-yandex-http-adapter-req-id',
    'x-yandex-req-id',
    'x-real-ip',
    'x-real-remote-ip',
    'x-yandex-ip',
    'x-forwarded-for',
    'x-forwarded-for-y',
    'cookie',
    'x-yandex-expflags-pre',
    'x-yandex-expboxes',
    'x-yandex-expboxes-crypted',
    'x-yandex-expflags',
];

$prepare_headers = ($headers, $req_id, $type) -> (
    ListExtend(
        ListFilter(
            String::SplitToList($headers, '~'),
            ($header) -> {
                $parts = String::SplitToList($header, ': ');
                RETURN NOT ListHas($headers_to_delete, String::AsciiToLower($parts[0]))
            }
        ), 
        [
            'X-Pulse-Request-Id: ' || $req_id,
            'X-Pulse-Request-Type: ' || $type
        ]
    )
);

$extract_cookies = ($headers) -> (
    ListFlatten(
        ListNotNull(
            ListMap(
                String::SplitToList($headers, '~'),
                ($header) -> {
                    $parts = String::SplitToList($header, ': ');
                    RETURN IF(
                        String::AsciiToLower($parts[0]) == 'cookie',
                        String::SplitToList($parts[1], '; '),
                        NULL
                    )
                }
            )
        )
    )
);

INSERT INTO `$output_table` WITH TRUNCATE
SELECT
    CAST((ROW_NUMBER() over w) AS String) AS id,
    $prepare_headers(headers, CAST(RandomUuid(headers) AS String), 'REQUEST_TYPE_APPHOST') AS headers,
    $extract_cookies(headers) AS cookies,
    'GET' AS method,
    String::JoinFromList(["http://$report_host", path, '&', String::JoinFromList($base_query_params, '&')], '') AS uri,
    ToBytes(
        Yson::SerializeJson(
            Yson::From({
                'type': 'base',
                'req_id': CAST(RandomUuid(headers) AS String)
            })
        )
    ) AS userdata
FROM
    `$input_table`
WINDOW w AS ()
