$dataset = (
    SELECT
        String::Strip(
            Url::Decode(
                Url::GetCGIParam(url, 'text')
            )
        ) as text,
        transfer_size,
        templates_time
    FROM $table_name
    WHERE 
        service == 'search'
        AND ui == 'touch'
        AND is_ajax == False 
        AND is_correct_nt == True
);

$p95_ts = SELECT PERCENTILE(transfer_size, 0.95) FROM $dataset;
$p95_tt = SELECT PERCENTILE(templates_time, 0.95) FROM $dataset;

$result = (
    SELECT
        text,
        COUNT(*) as cnt
    FROM $dataset
    WHERE text IS NOT NULL
    AND Math::FuzzyEquals(transfer_size, $p95_ts, 0.1)
    AND Math::FuzzyEquals(templates_time, $p95_tt, 0.1) 
    GROUP BY text
    ORDER BY cnt DESC
    LIMIT $limit
);

SELECT text FROM $result;
