import os

from datetime import datetime

from sandbox.projects.sandbox_ci.pulse.yql_query_builder import YQLQueryBuilder


def build_query(project, platform, counter, logs_date, limit, **tpl_vars):
    query_builder = YQLQueryBuilder(tasks_path=os.path.dirname(__file__))

    return query_builder.build(
        project,
        platform,
        date=logs_date if logs_date else datetime.now().strftime('%Y-%m-%d'),
        counter=counter or '',
        limit=limit,
        **tpl_vars
    )
