USE hahn;

PRAGMA yt.Pool = 'velocity';

$table_src = (
    SELECT Path
    FROM FOLDER(`home/trencher/ammo`)
    WHERE Type='table'
    AND CAST('$date' AS Date) - CAST(TableName(Path) AS Date) >= DateTime::IntervalFromDays(0)
    AND CAST('$date' AS Date) - CAST(TableName(Path) AS Date) < DateTime::IntervalFromDays(7)
    ORDER BY Path DESC
    LIMIT 1
);

$table_name = Unwrap($table_src, "Error: no tables available for date: $date");
