$to_list = ($structs) -> (ListMap(
    ListFilter($structs, ($struct) -> ($struct.name != 'host')),
    ($struct) -> ($struct.name || ": " || $struct.value))
);

$serialize = ($yson) -> {
  $structs = Yson::ConvertTo(
    $yson,
    List<Struct<name: String, value: String>>,
    Yson::Options(True as AutoConvert)
  );
  return String::JoinFromList($to_list($structs), "~")
};

$isMain = HyperScan::Grep("^/news/(index|\\?|$)");
$isRubric = HyperScan::Grep("^/news/(rubric|region)");
$isStory = HyperScan::Grep("^/news/story");

$table_news_src = (
    SELECT Path
    FROM FOLDER(`logs/news-scarab-access-log/1d`)
    WHERE Type='table'
    AND CAST('$date' AS Date) - CAST(TableName(Path) AS Date) <= DateTime::IntervalFromDays(7)
    ORDER BY Path DESC
    LIMIT 1
);

$table_news_name = Unwrap($table_news_src, "Error: no tables available for date: $date");

DEFINE SUBQUERY $getRequests($rePage, $platform) AS
  SELECT 
    httpRequest as path, 
    $serialize(httpHeaders) as headers
  FROM $table_news_name
  WHERE true
    AND httpStatus = 200
    AND httpMethod = 'GET'
    AND userDevice = $platform
    AND $rePage(httpRequest)
    AND not String::Contains(httpRequest, '&ajax=1')
  LIMIT
      $limit
  ;
END DEFINE;
