SELECT
    headers,
    request as path
FROM (
    SELECT
        headers,
        request,
        Url::Parse(Url::Decode(Url::GetCGIParam(request, 'text'))) as turboUrl
    FROM
        $table_name
    WHERE
        page == '/turbo'
        AND COALESCE(Url::GetCGIParam(request, 'd'), '0') != '1'
        AND COALESCE(Url::GetCGIParam(request, 'platform'), 'touch') != 'desktop'
        AND Url::GetCGIParam(request, 'ajax') IS NULL
)
WHERE
    turboUrl.Host NOT LIKE '%yandex%'
LIMIT
    $limit
;
