$table_ydo_src = (
    SELECT Path
    FROM FOLDER(`home/logfeller/logs/http_adapter-access-log/1d`)
    WHERE Type='table'
    AND CAST('$date' AS Date) - CAST(TableName(Path) AS Date) <= DateTime::IntervalFromDays(7)
    ORDER BY Path DESC
    LIMIT 1
);

$table_ydo_name = Unwrap($table_ydo_src, "Error: no tables available for date: $date");

$ua_devicetype = ($ua) -> {
    $parsed = UserAgent::Parse($ua);
    RETURN CASE
        WHEN NOT $parsed.isBrowser OR $parsed.isEmulator OR $parsed.isRobot THEN ''
        WHEN $parsed.isTablet THEN 'tablet'
        WHEN $parsed.isTouch or $parsed.isMobile THEN 'touch'
        ELSE 'desktop'
    END
};
