# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.common.types import resource as ctr


class TicountPlan(sdk2.Resource):
    """
        Ticount plan
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class TicountLogs(sdk2.Resource):
    """
        Ticount logs
    """
    releasable = False
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererPhantomData(sdk2.Resource):
    """
        Данные для обстрела Report Renderer с помощью dolbilo
        В сыром формате phantom
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererPlan(sdk2.Resource):
    """
        Данные для обстрела Report Renderer с помощью dolbilo
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererPlanJson(sdk2.Resource):
    """
        Данные для обстрела Report Renderer в виде JSON-строк
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererPhantomDataApphost(sdk2.Resource):
    """
        Данные для обстрела Report Renderer в режиме аппхоста с помощью dolbilo
        В сыром формате phantom
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererPlanApphost(sdk2.Resource):
    """
        Данные для обстрела Report Renderer в режиме аппхоста с помощью dolbilo
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class PulseShooterLogs(sdk2.Resource):
    """
        Логи Pulse Shooter
    """
    releasable = False
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class PulseShooterResponses(sdk2.Resource):
    """
        HTML и JSON ответы, полученные Pulse Shooter
    """
    releasable = False
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class PulseBinary(sdk2.Resource):
    """
        Сборка Pulse Shooter
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class PulseStaticLogs(sdk2.Resource):
    """
        Логи Pulse Static
    """
    releasable = False
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class PulseStaticDiff(sdk2.Resource):
    """
        Diff Pulse Static
    """
    releasable = False
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class SearchParsedAccessLog(sdk2.Resource):
    """
        JSON data from access-log
    """
    releasable = True
    executable = False
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class ReportRendererApphostFailedBodies(sdk2.Resource):
    """
        Report renderer Apphost bodies that were not successfully parsed
    """
    auto_backup = True
    any_arch = True
    releasable = False
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String


class PulseShooterWizardWeights(sdk2.Resource):
    """
        Wizard weights
    """
    releasable = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String
