#  -*- coding: utf-8 -*-
from sandbox.common.utils import classproperty


class Stage(object):
    """
    Базовый класс стадий Double Shooting
    """
    STAGE_NAME = None

    def __init__(self, master_task):
        """
        :param master_task:
        """
        self._master_task = master_task

    @classproperty
    def _context_key(cls):
        if cls.STAGE_NAME is None:
            raise Exception('Stage name is not set')

        return '_stages_' + cls.STAGE_NAME + '_results'

    @classmethod
    def fetch_context_from(cls, master_task):
        return getattr(master_task.Context, cls._context_key, None) or {}

    def execute(self, *args):
        raise NotImplementedError()

    def push_context_to_master_task(self, ctx):
        setattr(self._master_task.Context, self._context_key, ctx)
