# coding=utf-8
import math

PERCENTILES_TO_CALC = (25, 50, 75, 80, 95, 99)


def percentile(arr, p):
    """
    Находит заданный процентиль из списка значений

    :param arr: - Список значений
    :type arr: list
    :param p: - Задает процентиль от 0 до 100
    :type p: float

    :return: - Вычесленный процентиль
    :rtype: float
    """

    arr_sorted = sorted(arr)
    p /= 100.0
    n = int(math.ceil(p * len(arr_sorted)))
    return arr_sorted[n - 1]


def mean(values):
    """
    :type values: list
    :return: float
    """
    return reduce(lambda x, y: x + y, values) / float(len(values))
