import json
import os

from sandbox.projects.sandbox_ci.utils.context import Node
from sandbox.projects.sandbox_ci.utils.process import run_process


class TicountRunner(object):
    def __init__(self, package, node_js_version):
        self._package = package
        self._node_js_version = node_js_version

    def write(self, url, metrics_log, traces_dir=None, mobile=False, workers=10, repeat=10):
        command = [
            'write',
            '--url "{}"'.format(url),
            '--repeat {}'.format(repeat),
            '--workers {}'.format(workers),
            '--metrics-log {}'.format(metrics_log),
        ]

        if traces_dir:
            command.append('--traces-dir {}'.format(traces_dir))

        if mobile:
            command.append('--mobile')

        return self._run_command(command, 'ticount_write')

    def compare(self, metrics_base, metrics_actual, limits=None, excesses_log=None, report=None):
        command = [
            'compare',
            '--skip-shooting',
            '--metrics-log-base {}'.format(metrics_base),
            '--metrics-log-actual {}'.format(metrics_actual),
        ]

        if limits:
            config_file = os.path.join(os.getcwd(), 'config.json')
            with open(config_file, 'w') as fd:
                json.dump(dict(limits=limits), fd)
            command.append('--config {}'.format(config_file))

        if excesses_log:
            command.append('--excesses-log {}'.format(excesses_log))

        if report:
            command.extend((
                '--report-out {}'.format(report),
                '--report-format simple'
            ))

        compare_process = self._run_command(command, 'ticount_compare')

        with open(compare_process.stdout_path, 'r') as compare_result_file:
            return compare_result_file.read()

    def test(self):
        process = self._run_command(['test'], 'ticount_test', check=False)
        return process.returncode == 0

    def _run_command(self, command, log_prefix, **kwargs):
        with Node(self._node_js_version):
            return run_process(
                ['npx', self._package] + command,
                shell=True,
                log_prefix=log_prefix,
                environment=dict(
                    os.environ,
                    npm_config_registry='https://npm.yandex-team.ru',
                ),
                **kwargs
            )
