# coding=utf-8
import contextlib
import logging
import shutil
import time
import urllib2

from sandbox import sdk2
from sandbox.common.errors import TaskFailure

YQL_TOKEN_OWNER = 'REPORT_TEMPLATES'
YQL_TOKEN_NAME = 'robot-drunken-flash-yql'
MAX_REQUEST_RETRIES = 10


def download_from_yql(url, dest_file, token=None, max_retries=MAX_REQUEST_RETRIES):
    if token is None:
        token = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)

    request = urllib2.Request(url, headers={
        'Authorization': 'OAuth %s' % token
    })

    retry_count = 0
    while True:
        try:
            with contextlib.closing(urllib2.urlopen(request)) as src_fp, open(dest_file, 'w') as dest_fp:
                shutil.copyfileobj(src_fp, dest_fp)
            break
        except urllib2.URLError as e:
            logging.warning('YQL download error: %s', e)
            time.sleep(5)

            retry_count += 1
            if retry_count >= max_retries:
                raise TaskFailure('Unable to download resource from YQL: %s' % e)
