#  -*- coding: utf-8 -*-
import logging

from sandbox.projects.sandbox_ci.utils.arcanum import format_review_request_url
from sandbox.projects.sandbox_ci.utils.github import format_pull_request_url
from sandbox.projects.sandbox_ci.utils.ref_formatter import is_arcanum_ref
from sandbox.projects.sandbox_ci.utils.ref_formatter import is_github_ref
from sandbox.projects.sandbox_ci.utils.ref_formatter import strip_ref_prefix
from sandbox.projects.sandbox_ci.managers.release import StartrekClient


def format_pr_uri(owner, repo, ref):
    if is_github_ref(ref):
        return format_pull_request_url(owner, repo, strip_ref_prefix(ref))

    if is_arcanum_ref(ref):
        return format_review_request_url(strip_ref_prefix(ref))

    raise Exception('Invalid ref name: {ref}'.format(ref=ref))


def format_tracker_query(pr_uri):
    logging.debug('PR uri: {pr_uri}'.format(pr_uri=pr_uri))

    return 'Queue: "VELOCITYAUDIT" AND Pull-request: "{pr_uri}" AND Status: "Confirmed"'.format(pr_uri=pr_uri)


def fetch_velocity_audit_issues(startrek_token, owner, repo, ref):
    pr_uri = format_pr_uri(owner, repo, ref)
    query = format_tracker_query(pr_uri)

    logging.debug('Fetching tickets by: {query}'.format(query=query))

    startrek_client = StartrekClient(startrek_token)
    issues = startrek_client.search(query)

    logging.debug('Issues: {issues}'.format(issues=issues))

    return map(startrek_client.get_issue_key, issues)
