# -*- coding: utf-8 -*-

from sandbox.common.errors import TaskFailure


class QloudException(Exception):
    _message = 'Qloud error'

    def __init__(self, data=None):
        self._data = data or {}

    @property
    def message(self):
        return self._message.format(**self._data)


class QloudReadonly(TaskFailure, QloudException):
    _message = 'Qloud is in readonly mode'


class QloudPollingTimeout(TaskFailure, QloudException):
    _message = 'Qloud polling timeout. Max attempts reached'


class QloudDeployFailed(TaskFailure, QloudException):
    _message = 'Qloud environment {objectId} deploy failed. (status={status}, statusMessage={statusMessage})'
