# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.sandbox_ci.release.ReleaseIssueActions import ReleaseIssueActions, CommitIdentifierParameters


class SandboxCiAddIssue(ReleaseIssueActions):
    """Добавить задачу или пулл-реквест в релизную ветку"""

    class Parameters(ReleaseIssueActions.Parameters):
        with sdk2.parameters.Group('Операция') as version_block:
            from_branch = sdk2.parameters.String(
                'В какой ветке искать коммиты',
                default='dev',
                description='Коммиты из этой ветки будут перенесены в релизную ветку.',
                required=True,
            )

            release_branch = sdk2.parameters.String(
                'Релизная ветка',
                default='release/v1.?.?',
                description='Ветка в которую будут добавлены коммиты по задаче.',
                required=True,
            )

            update_issue = sdk2.parameters.Bool(
                'Обновить релизный тикет',
                description='Обновляет описание и связи релизной задачи,'
                            'а также переводит добавленные тикеты в указанный статус.',
                default=True,
                sub_fields={'true': ['next_status']}
            )

            next_status = sdk2.parameters.String(
                'Статус',
                default='rc',
                description='В какой статус переводить добавленные задачи.'
            )

            commit_identifiers_block = CommitIdentifierParameters

    script_path = 'script/add-issue-or-pr.js'

    def get_action_title(self):
        return 'Добавить в {}'.format(self.get_branch_id())

    def get_commit_identifiers(self):
        return [
            identifier.strip()
            for identifier in self.Parameters.commit_identifiers
            if identifier and identifier.strip()
        ]

    def get_branch_id(self):
        return '{owner}/{repo}@{branch}'.format(
            owner=self.Parameters.project_owner,
            repo=self.Parameters.project_repo,
            branch=self.Parameters.release_branch,
        )

    def get_script_params(self):
        args = {
            'owner': self.Parameters.project_owner,
            'repo': self.Parameters.project_repo,
            'base-branch': self.Parameters.from_branch,
            'branch': self.Parameters.release_branch,
            'commit-identifiers': ','.join(self.get_commit_identifiers())
        }

        if self.Parameters.update_issue:
            args['next-status'] = self.Parameters.next_status
            args['update-issue'] = self.Parameters.update_issue

        return args
