# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.sandbox.resources import LXC_CONTAINER

from generated import *
from releasers import ROBOTS, INFRAMSK_TEAM, INFRA_TEAM
from template_packages import *


class SANDBOX_CI_LXC_IMAGE(LXC_CONTAINER):
    """
        Tarball with Sandbox CI LXC image
    """
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = INFRA_TEAM


class SANDBOX_CI_BOWER_BUNDLE(sdk2.Resource):
    """
    Bundle with bower dependencies
    """
    auto_backup = True
    any_arch = True
    __default_attribute__ = sdk2.parameters.String
    # TODO: attributes


class SANDBOX_CI_BOWER_IMAGE(sdk2.Resource):
    """
    Squashfs image with bower dependencies
    """
    auto_backup = True
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class SANDBOX_CI_NODE_MODULES_BUNDLE(sdk2.Resource):
    """
    Bundle with npm dependencies
    """
    auto_backup = True
    any_arch = False
    __default_attribute__ = sdk2.parameters.String
    # TODO: attributes


class SANDBOX_CI_NODE_MODULES_IMAGE(sdk2.Resource):
    """
    Squashfs image with npm dependencies
    """
    auto_backup = True
    any_arch = False
    __default_attribute__ = sdk2.parameters.String


class SANDBOX_CI_LOCAL_NODE_MODULES_CACHE(sdk2.Resource):
    """
    Archive with local node_modules cache for https://st.yandex-team.ru/FEI-10919
    """
    auto_backup = True
    # platform (linux, darwin, etc.) is specified in resource parameters among with additional info
    any_arch = True
    ttl = 30
    __default_attribute__ = sdk2.parameters.String


class SANDBOX_CI_ARTIFACT(sdk2.Resource):
    """
    Bundle with typed artifact
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String
    # TODO: attributes


class SANDBOX_CI_SQUASHFS_TOOLS(sdk2.Resource):
    """
    Bundle with squashfs tools
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String
    releasers = INFRA_TEAM


class SANDBOX_CI_BUILD_CACHE_IMAGE(sdk2.Resource):
    """
    Squashfs image with build cache
    """
    auto_backup = True
    any_arch = False
    __default_attribute__ = sdk2.parameters.String


class SandboxCiGitCache(sdk2.Resource):
    """
    Bundle with git cache
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String


class SandboxCiScripts(sdk2.Resource):
    """
    Bundle with typed artifact
    """
    auto_backup = True
    any_arch = True
    releasable = True

    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String

    releasers = ['robot-trendbot'] + ROBOTS + INFRAMSK_TEAM


class HermioneStabilityIndex(sdk2.Resource):
    """
    Bundle with stability index (see @yandex-int/hermione-muted-tests package).
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String


class LibServantClient(sdk2.Resource):
    """
        Клиентская библиотека аппхоста. Используется, например, в темпларе
    """
    auto_backup = True
    executable = True
    releasable = True
    any_arch = False

    releasers = INFRA_TEAM


class HermioneSkipTestsList(sdk2.Resource):
    """
    json with skipped tests
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String


class InfrastatsReport(sdk2.Resource):
    """
    bundle with statistic of flaky hermione/gemini tests
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String


class LogfellerStdinParserBinary(sdk2.Resource):
    """
    logfeller/bin/stdin_parser binary
    """
    auto_backup = True
    executable = True
    releasable = True
    any_arch = False

    releasers = INFRA_TEAM


class BlockstatYsonLog(sdk2.Resource):
    """
    blockstat log converted to yson
    """
    auto_backup = True
    any_arch = True
    restart_policy = ctr.RestartPolicy.DELETE
    __default_attribute__ = sdk2.parameters.String
