# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import resource as ctr

from releasers import ROBOTS, INFRA_TEAM


class ReportWebTemplatesPackage(sdk2.Resource):
    auto_backup = True
    executable = True

    __default_attribute__ = sdk2.parameters.String

    restart_policy = ctr.RestartPolicy.IGNORE  # В момент перезапуска таски с ресурсом ничего не делать

    releasable = True
    releasers = ['sanity'] + ROBOTS + INFRA_TEAM


class WebMicroPackage(ReportWebTemplatesPackage):
    pass


class WebLowloadMicroPackage(ReportWebTemplatesPackage):
    pass


class WebExp1MicroPackage(ReportWebTemplatesPackage):
    pass


class WebExp2MicroPackage(ReportWebTemplatesPackage):
    pass


class WebExp3MicroPackage(ReportWebTemplatesPackage):
    pass


class WebExp4MicroPackage(ReportWebTemplatesPackage):
    pass


class WebNotificationsMicroPackage(ReportWebTemplatesPackage):
    pass


class WebAdvancedMicroPackage(ReportWebTemplatesPackage):
    pass


class WebCustomizeMicroPackage(ReportWebTemplatesPackage):
    pass


class WebRedirWarningMicroPackage(ReportWebTemplatesPackage):
    pass


class WebInfectedMicroPackage(ReportWebTemplatesPackage):
    pass


class WebSavedCopyMicroPackage(ReportWebTemplatesPackage):
    pass


class WebMischandlersMicroPackage(ReportWebTemplatesPackage):
    pass


class WebJsonproxyMicroPackage(ReportWebTemplatesPackage):
    pass


class WebSitesearchMicroPackage(ReportWebTemplatesPackage):
    pass


class WebChatMicroPackage(ReportWebTemplatesPackage):
    pass


class WebTurboMicroPackage(ReportWebTemplatesPackage):
    pass


class WebTurboExp1MicroPackage(WebTurboMicroPackage):
    pass


class WebTurboExp2MicroPackage(WebTurboMicroPackage):
    pass


class WebGrannyMicroPackage(ReportWebTemplatesPackage):
    pass


class WebGrannyFreezeMicroPackage(ReportWebTemplatesPackage):
    pass


class NewsDesktopMicroPackage(ReportWebTemplatesPackage):
    pass


class NewsTouchMicroPackage(ReportWebTemplatesPackage):
    pass


class NewServiceMicroPackage(ReportWebTemplatesPackage):
    pass


class TestServiceMicroPackage(ReportWebTemplatesPackage):
    pass


class WebForeverData2MicroPackage(ReportWebTemplatesPackage):
    pass


class WebEducationMicroPackage(ReportWebTemplatesPackage):
    pass


class WebTestMicroPackage(ReportWebTemplatesPackage):
    pass


class WebHardwareCalcPackage(ReportWebTemplatesPackage):
    pass


class WebEduMicroPackage(ReportWebTemplatesPackage):
    releasers = ['konovailk', 'pownedy', 'ssav', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebKpMicroPackage(ReportWebTemplatesPackage):
    releasers = ['baymer', 'robot-kp-js'] + ROBOTS + INFRA_TEAM

class WebNeoMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ya-belov', 'gridsane', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebNewsMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ya-belov', 'gridsane', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebNewsGrannyMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ya-belov', 'garris', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebNewsPartnersMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ya-belov', 'gridsane', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebSportMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ya-belov', 'dm-fish', 'nekrashevich', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebTutorMicroPackage(ReportWebTemplatesPackage):
    releasers = ['konovailk', 'pownedy', 'ssav', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebHealthMicroPackage(ReportWebTemplatesPackage):
    releasers = ['hatroman', 'coffeeich', 'fiberthrone', 'garipov', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebStaffAvailabilityMicroPackage(ReportWebTemplatesPackage):
    releasers = ['ertema', 'barraquete', 'annvas', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebChannelsMicroPackage(ReportWebTemplatesPackage):
    releasers = ['konovailk', 'pownedy', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebYdoMicroPackage(ReportWebTemplatesPackage):
    releasers = ['vitoshnev', 'mishanga', 'i-zuev', 'alexdivin', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebYdoAdminMicroPackage(ReportWebTemplatesPackage):
    releasers = ['vitoshnev', 'mishanga', 'i-zuev', 'alexdivin', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebButterflyMicroPackage(ReportWebTemplatesPackage):
    releasers = ['vitoshnev', 'mishanga', 'i-zuev', 'alexdivin', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebUgcMicroPackage(ReportWebTemplatesPackage):
    releasers = ['mishanga', 'an9eldust', 'isqua', 'vlandreev', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebPatentsMicroPackage(ReportWebTemplatesPackage):
    releasers = ['alexvin', 'robot-frontend'] + ROBOTS + INFRA_TEAM


class WebDiscussionsMicroPackage(ReportWebTemplatesPackage):
    releasers = ['av-denis', 'xxxxxx', 'alexeyborisov', 'marsgpl', 'grundy'] + ROBOTS + INFRA_TEAM


class WebQuasarMicroPackage(ReportWebTemplatesPackage):
    releasers = ['allonsydaniel', 'a-salnikov', 'san4eyz', 'robot-frontend'] + ROBOTS + INFRA_TEAM

class WebEcomShopMicroPackage(ReportWebTemplatesPackage):
    releasers = ['mviktorov', 'hatroman', 'eshreder'] + ROBOTS + INFRA_TEAM

class WebEcomSinsMicroPackage(ReportWebTemplatesPackage):
    releasers = ['nox-wave', 'eshreder'] + ROBOTS + INFRA_TEAM

class ReportMmImagesTemplatesPackage(sdk2.Resource):
    """
        Архив с шаблонами вёрстки картинок
    """
    auto_backup = True
    executable = True
    releasable = True

    __default_attribute__ = sdk2.parameters.String

    restart_policy = ctr.RestartPolicy.IGNORE  # В момент перезапуска таски с ресурсом ничего не делать

    releasers = [
        'tkatliarova',
        'sanity',
        'sbmaxx',
        'nerevar',
        'alex-k',
        'nbahob',
        'mokcrimea',
        'dndushkin',
        'yurich',
        'beam',
        'webmisha'
    ] + ROBOTS + INFRA_TEAM


class ReportMmVideoTemplatesPackage(sdk2.Resource):
    """
        Архив с шаблонами вёрстки видео
    """
    auto_backup = True
    executable = True
    releasable = True

    __default_attribute__ = sdk2.parameters.String

    restart_policy = ctr.RestartPolicy.IGNORE  # В момент перезапуска таски с ресурсом ничего не делать

    releasers = ReportMmImagesTemplatesPackage.releasers + ['xescoder']


class VideoMicroPackage(ReportMmVideoTemplatesPackage):
    pass


class VideoGrannyDesktopMicroPackage(VideoMicroPackage):
    pass


class VideoGrannyTouchPhoneMicroPackage(VideoMicroPackage):
    pass


class ImagesMicroPackage(ReportMmImagesTemplatesPackage):
    pass


class ImagesGrannyDesktopMicroPackage(ImagesMicroPackage):
    pass


class ImagesSmartMicroPackage(ImagesMicroPackage):
    pass


class ImagesExpMicroPackage(ImagesMicroPackage):
    pass


class ImagesTemporaryMicroPackage(ReportMmImagesTemplatesPackage):
    pass


class WebSmartcameraMicroPackage(ImagesMicroPackage):
    pass


class VideoHostingRuntimeMicroPackage(ReportWebTemplatesPackage):
    PLAYER_TEAM = ['xescoder', 'alex-gusev', 'eburakov', 'goncharov03', 'numminorihsf', 'bettapo', 'tenenev', 'dekker']
    releasers = ['fawnd2', 'i-sokolov', 'woodie'] + ROBOTS + INFRA_TEAM + PLAYER_TEAM
