# -*- coding: utf-8 -*-

from sandbox.common.types import client as ctc

from sandbox.projects.resource_types import REPORT_TEMPLATES_PACKAGE, REPORT_STATIC_PACKAGE

# from sandbox.projects.sandbox_ci import parameters
from sandbox.projects.sandbox_ci.task import BaseMetaTask
from sandbox.projects.sandbox_ci.utils.static_host import get_static_workcopy_name
from sandbox.projects.sandbox_ci.sandbox_ci_dummy_gemini import SandboxCiDummyGemini
from sandbox.projects.sandbox_ci.sandbox_ci_dummy_hermione import SandboxCiDummyHermione
from sandbox.projects.sandbox_ci.sandbox_ci_dummy_linters import SandboxCiDummyLinters
from sandbox.projects.sandbox_ci.sandbox_ci_palmsync.dummy_validate import SandboxCiPalmsyncDummyValidate
# from sandbox.projects.sandbox_ci.pulse.subtasks import create_pulse_subtasks


class SandboxCiDummy(BaseMetaTask):
    """
    Задача-заглушка для тестирования Sandbox и измерения накладных расходов
    """
    # class Parameters(BaseMetaTask.Parameters):
    #     with sdk2.parameters.Group('Pulse') as pulse_block:
    #         pulse_should_report_to_stat = parameters.pulse_should_report_to_stat()

    class Requirements(BaseMetaTask.Requirements):
        client_tags = ctc.Tag.GENERIC
        kill_timeout = 600

    project_name = 'dummy'

    lifecycle_steps = {
        # создаём директорию node_modules вместо npm i
        'npm_install': 'mkdir -p node_modules',

        # создаём директорию libs вместо bower i
        'bower_install': 'mkdir -p libs',

        # создаём директории pages-* вместо make build
        'build': 'mkdir -p pages-desktop pages-touch-pad pages-touch-phone',

        # создаём dummy артефакты
        'artifacts-dummy': [
            'tar -zcf ../dummy.tar.gz .',
        ],
        'artifacts-dummy-templates': [
            'tar -zcf ../dummy-templates.tar.gz .',
        ],
        'artifacts-dummy-static': [
            'tar -zcf ../dummy-static.tar.gz .',
        ],
        'artifacts-features': [
            'mkdir -p features/something',
            '&& touch features/something/something.testpalm.yml',
            '&& tar -zcf ../features.tar.gz features'
        ],
        'artifacts-gemini': [
            'mkdir -p gemini/something',
            '&& touch gemini/something/something.gemini.js',
            '&& tar -zcf ../gemini.tar.gz gemini npm-shrinkwrap.json'
        ],
        'artifacts-hermione': [
            'mkdir -p hermione/something',
            '&& touch hermione/something/something.hermione.js',
            '&& tar -zcf ../hermione.tar.gz hermione npm-shrinkwrap.json'
        ],
        'artifacts-unit-tests': [
            'tar', '-zcf', '../unit-tests.tar.gz',
            '--exclude-vcs',
            '--exclude=./libs',
            '--exclude=./gemini',
            '--exclude=./hermione',
            '--exclude=./features',
            '--exclude=./node_modules',
            '.',
        ],
        'prepare-working-copy': [
            'mkdir -p {project_dir}',
            '&& touch {project_dir}/npm-shrinkwrap.json',
            '&& touch {project_dir}/bower.json',
        ],
    }

    lifecycle_artifacts_map = {
        'artifacts-dummy': ['dummy'],
        'artifacts-dummy-templates': ['dummy-templates'],
        'artifacts-dummy-static': ['dummy-static'],
        'artifacts-features': ['features'],
        'artifacts-gemini': ['gemini'],
        'artifacts-hermione': ['hermione'],
        'artifacts-unit-tests': ['unit-tests'],
    }

    artifacts_resource_types = {
        'dummy-templates': REPORT_TEMPLATES_PACKAGE,
        'dummy-static': REPORT_STATIC_PACKAGE,
    }

    @property
    def github_context(self):
        return u'Автосборка'

    def prepare_sources(self):
        # не клонируем рабочую копию
        self.lifecycle('prepare-working-copy', work_dir=self.working_path())

    def check_lfs(self):
        # не проверяем lfs файлы, потому что у нас нет репозитория
        pass

    def declare_subtasks(self):
        subtasks = [
            self.create_linters_subtask(),
            self.create_palmsync_validate_subtask(),
        ]

        test_tasks = []
        for platform in ['desktop', 'touch-pad', 'touch-phone']:
            gemini_task = self.create_gemini_subtask(platform=platform)
            if gemini_task:
                test_tasks.append(gemini_task)

            hermione_task = self.create_hermione_subtask(platform=platform)
            if hermione_task:
                test_tasks.append(hermione_task)

        subtasks += test_tasks
        # subtasks += create_pulse_subtasks(self, platforms=['desktop', 'touch', 'touch-pad'])

        return subtasks

    def create_linters_subtask(self, wait_tasks=None):
        return self.meta.declare_subtask(
            task_type=SandboxCiDummyLinters,
            wait_tasks=wait_tasks,
            description=self.Parameters.description,
            project_git_base_ref=self.Parameters.project_git_base_ref,
            project_git_base_commit=self.Parameters.project_git_base_commit,
            project_git_merge_ref=self.Parameters.project_git_merge_ref,
            project_git_merge_commit=self.Parameters.project_git_merge_commit
        )

    def create_gemini_subtask(self, platform, wait_tasks=None, **params):
        return self.create_test_subtask(
            task_type=SandboxCiDummyGemini,
            platform=platform,
            build_artifacts_resources=[self.get_registered_artifact_id(a) for a in ('dummy', 'gemini')],
            wait_tasks=wait_tasks,
            reusable=True,
            **params
        )

    def create_hermione_subtask(self, platform, wait_tasks=None, **params):
        return self.create_test_subtask(
            task_type=SandboxCiDummyHermione,
            platform=platform,
            build_artifacts_resources=[self.get_registered_artifact_id(a) for a in ('dummy', 'hermione', 'features')],
            wait_tasks=wait_tasks,
            reusable=True,
            **params
        )

    def create_test_subtask(self, task_type, platform, wait_tasks=None, reusable=False, **params):
        return self.meta.declare_subtask(
            task_type=task_type,
            wait_tasks=wait_tasks,
            description=self.get_test_subtask_description(platform),
            platform=platform,
            reusable=reusable,
            ref=self.ref,
            additional_tags=[platform],
            **params
        )

    def create_palmsync_validate_subtask(self):
        return self.meta.declare_subtask(
            task_type=SandboxCiPalmsyncDummyValidate,
            description=self.Parameters.description,
            build_artifacts_resources=[
                self.get_registered_artifact_id('gemini'),
                self.get_registered_artifact_id('hermione'),
                self.get_registered_artifact_id('features'),
            ],
        )
