# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.task import BaseGeminiTask
from sandbox.projects.sandbox_ci.task.test_task.BaseTestTask import BaseTestTask


class SandboxCiDummyGemini(BaseGeminiTask):
    """
    Заглушка для Gemini-тестов dummy задачи
    """

    class Requirements(BaseTestTask.Requirements):
        cores = 1

        class Caches(BaseTestTask.Requirements.Caches):
            pass

    project_name = 'dummy'

    lifecycle_steps = {
        'npm_install': 'mkdir -p node_modules',
        'test': [
            'echo',
            '{run_cmd} {run_opts} {run_custom_opts}',
            '&& mkdir -p .templar/rr-logs .templar/clickdaemon-logs stat-reporter {tool}-report',
            '&& touch faildump.json stat-reporter/{tool}.json stat-reporter/{tool}.html {tool}-report/index.html',
        ]
    }

    @property
    def run_cmd(self):
        return 'gemini test'
