# -*- coding: utf-8 -*-

from sandbox.common.types import client as ctc

from sandbox.projects.sandbox_ci.task import BaseHermioneTask


class SandboxCiDummyHermione(BaseHermioneTask):
    """
    Заглушка для Hermione-тестов dummy задачи
    """

    class Requirements(BaseHermioneTask.Requirements):
        client_tags = ctc.Tag.GENERIC

    project_name = 'dummy'

    lifecycle_steps = {
        'npm_install': 'mkdir -p node_modules',
        'test': [
            'echo',
            '{run_cmd} {run_opts} {run_custom_opts}',
            '&& mkdir -p .templar/rr-logs .templar/clickdaemon-logs stat-reporter {tool}-report',
            '&& touch faildump.json stat-reporter/{tool}.json stat-reporter/{tool}.html {tool}-report/index.html',
        ],
        'report': 'true',
    }

    @property
    def run_cmd(self):
        return 'hermione'
