# -*- coding: utf-8 -*-

from sandbox.common.types import client as ctc

from sandbox.projects.sandbox_ci.task.BaseLintersTask import BaseLintersTask


class SandboxCiDummyLinters(BaseLintersTask):
    """
    dummy-таск линтеров
    """

    class Requirements(BaseLintersTask.Requirements):
        client_tags = ctc.Tag.GENERIC

    project_name = 'dummy'

    lifecycle_steps = {
        'npm_install': 'mkdir -p node_modules',
        'bower_install': 'mkdir -p libs',
        'stage_changes': 'true',
        'prepare-working-copy': [
            'mkdir -p {project_dir}',
            '&& touch {project_dir}/npm-shrinkwrap.json',
            '&& touch {project_dir}/bower.json',
        ],
    }

    linters = {
        'jscs': 'echo ok > jscs-html-report.html',
        'jshint': 'echo ok > jshint-html-report.html',
        'bemhint': 'echo ok > bemhint-report.html',
        'stylint': 'echo ok',

        'bemhtml_js': 'echo ok',
        'csscomb': 'echo ok',
        'check_only': 'echo ok',
        'check-onmousedown': 'echo ok',
    }

    reports = {
        'jscs': 'jscs-html-report.html',
        'jshint': 'jshint-html-report.html',
        'bemhint': 'bemhint-report.html',
    }

    def prepare_sources(self):
        # не клонируем рабочую копию
        self.lifecycle('prepare-working-copy', work_dir=self.working_path())
