# -*- coding: utf-8 -*-

import json
from functools import partial

from sandbox import sdk2

from sandbox.projects.sandbox_ci.sandbox_ci_fiji_experiments.task import SandboxCiFijiExperiments
from sandbox.projects.sandbox_ci.task.experiments import BaseExperimentsReleaseRunnerTask


class SandboxCiFijiExperimentsReleaseRunner(BaseExperimentsReleaseRunnerTask):
    """
    Запуск релизных hermione тестов fiji с экспериментальными флагами
    """
    name = 'SANDBOX_CI_FIJI_EXPERIMENTS_RELEASE_RUNNER'
    project_task_type = 'SANDBOX_CI_FIJI'
    experiments_subtask_type = SandboxCiFijiExperiments

    class Parameters(BaseExperimentsReleaseRunnerTask.Parameters):
        with BaseExperimentsReleaseRunnerTask.Parameters.tests_parameters_block() as tests_parameters_block:
            use_file_to_pass_flags = sdk2.parameters.Bool(
                'Использовать файл в качестве транспорта флагов в шаблоны',
                description='По умолчанию флаги передаются через URL, @see FEI-11662.',
                default=False
            )

            with sdk2.parameters.RadioGroup(u'Сервис') as service:
                service.values['images'] = service.Value('images', default=True)
                service.values['video'] = service.Value('video', default=False)

    allowed_handlers = ['REPORT', 'VIDEO', 'IMAGES']

    def _find_report(self, task, report_type, **custom_attrs):
        return super(SandboxCiFijiExperimentsReleaseRunner, self)._find_report(
            task=task,
            report_type=report_type,

            project_service=self.Parameters.service,

            **custom_attrs
        )

    def get_tool_params(self, tool):
        params = {}

        env_prefix = self._get_env_prefix(tool)

        params.update(self.get_url_params(env_prefix))

        if tool == 'hermione-e2e':
            params.update(
                {'{}_TEST-ID'.format(env_prefix): self.Parameters.test_id}
            )
        elif self.Parameters.used_flags:
            if self.Parameters.use_file_to_pass_flags:
                params.update(
                    {'{}_EXP_FLAGS_FROM_FILE'.format(env_prefix): 'exp-flags.json'}
                )
            else:
                params.update(
                    {'{}_TEMPLATE_EXP_FLAGS'.format(env_prefix): ';'.join(self.encode_flags(self.Parameters.used_flags))}
                )

        return params

    def get_latest_release_task(self):
        return super(SandboxCiFijiExperimentsReleaseRunner, self).get_latest_release_task(
            services=[self.Parameters.service]
        )

    def run_project_experiments_task(self, templates_task, tests_task, **params):
        return super(SandboxCiFijiExperimentsReleaseRunner, self).run_project_experiments_task(
            templates_task,
            tests_task,

            service=self.Parameters.service,

            **params
        )
