# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.sandbox_ci.task.experiments import BaseExperimentsTask
from sandbox.projects.sandbox_ci.sandbox_ci_fiji_hermione import SandboxCiFijiHermione
from sandbox.projects.sandbox_ci.sandbox_ci_fiji_hermione_e2e import SandboxCiFijiHermioneE2E


class SandboxCiFijiExperiments(BaseExperimentsTask):
    """
    Мета-задача для запуска hermione тестов fiji с экспериментальными флагами
    """
    name = 'SANDBOX_CI_FIJI_EXPERIMENTS'

    project_name = u'fiji'

    class Parameters(BaseExperimentsTask.Parameters):
        with BaseExperimentsTask.Parameters.tests_block() as tests_block:
            with sdk2.parameters.RadioGroup(u'Сервис') as service:
                service.values['images'] = service.Value('images', default=True)
                service.values['video'] = service.Value('video', default=False)

    @property
    def build_artifact_types(self):
        return ['fiji']

    @staticmethod
    def _get_task_type(tool):
        if tool == 'hermione':
            return SandboxCiFijiHermione
        if tool == 'hermione-e2e':
            return SandboxCiFijiHermioneE2E

    def create_subtask(self, task_type, resources, platform, env, **kwargs):
        return super(SandboxCiFijiExperiments, self).create_subtask(
            task_type=task_type,
            resources=resources,
            platform=platform,
            env=env,

            service=self.Parameters.service,

            **kwargs
        )
