# -*- coding: utf-8 -*-

import os
import re
from sandbox import sdk2

from sandbox.common.utils import singleton_property
from sandbox.projects.sandbox_ci.sandbox_ci_hermione_e2e import SandboxCiHermioneE2E


class SandboxCiFijiHermioneE2E(SandboxCiHermioneE2E):
    name = 'SANDBOX_CI_FIJI_HERMIONE_E2E'

    class Parameters(SandboxCiHermioneE2E.Parameters):
        with sdk2.parameters.String('Service', required=True) as service:
            service.values[''] = service.Value('---', default=True)
            service.values['images'] = 'images'
            service.values['video'] = 'video'

    @property
    def run_cmd(self):
        return 'bin/fiji e2e'

    @property
    def run_opts(self):
        return '--service={} --platform={}'.format(self.Parameters.service, self.Parameters.platform)

    @property
    def report_description(self):
        return '{}/{}'.format(self.Parameters.service, self.Parameters.platform)

    @singleton_property
    def cache_parameters(self):
        parameters = super(SandboxCiHermioneE2E, self).cache_parameters
        parameters.update(service=self.Parameters.service)

        return parameters

    @property
    def report_common_attributes(self):
        return dict(
            super(SandboxCiHermioneE2E, self).report_common_attributes,
            # у класса Resource уже есть атрибут service
            project_service=self.Parameters.service
        )

    def set_environments(self):
        super(SandboxCiFijiHermioneE2E, self).set_environments()

        os.environ.update(self.browsers_config.format_sessions_per_browser_env_options())

    @property
    def json_reporter_file_path(self):
        return 'hermione-e2e-{}-{}.json'.format(self.Parameters.service, self.Parameters.platform)
