# -*- coding: utf-8 -*-

import copy

from sandbox.projects.sandbox_ci.task.BaseLintersTask import BaseLintersTask


class SandboxCiFijiLinters(BaseLintersTask):
    """ Таск для запуска линтеров fiji. """

    project_name = 'fiji'

    linters = {
        'eslint': '.githooks/pre-commit/linters/eslint',
        'stylint': '.githooks/pre-commit/linters/stylint',
        'stylelint': '.githooks/pre-commit/linters/stylelint',
        'tslint': '.githooks/pre-commit/linters/tslint',
        'svglint': '.githooks/pre-commit/linters/svglint',
        'destruct': '.githooks/pre-commit/linters/destruct',
        'expflags-schema': '.githooks/pre-commit/linters/expflags-schema',
        'expflags-typings': '.githooks/pre-commit/linters/expflags-typings',
        'tsc': '.githooks/pre-push/linters/tsc',
        'video-player-bucket-linter': 'bin/video-player-bucket-linter.js',
        'tsr-validate': '.githooks/pre-commit/linters/tsr-validate',
        'hermione-markdown': '.githooks/pre-commit/linters/hermione-markdown',
    }

    reports = {
        'stylelint': 'stylelint-html-report.html',
    }

    lifecycle_steps = copy.deepcopy(BaseLintersTask.lifecycle_steps)
    lifecycle_steps.update({
        'npm_install': 'npm ci',
    })
