# -*- coding: utf-8 -*-

import shutil
import copy
from sandbox.projects.sandbox_ci.task import BaseUnitTask
from sandbox.projects.sandbox_ci.utils.git import git_clone
from sandbox import sdk2
from sandbox.common.types import misc as ctm

RAMDRIVE_SIZE = 15 * 1024

class SandboxCiFijiUnitClient(BaseUnitTask):
    """
    Клиентские unit-тесты Картинок и Видео (mm-interfaces/fiji)
    """
    class Requirements(BaseUnitTask.Requirements):
        ramdrive = ctm.RamDrive(ctm.RamDriveType.TMPFS, RAMDRIVE_SIZE, None)

    project_name = 'fiji'

    unit_type = 'client'
    reports = {
        'results': 'index.html'
    }

    lifecycle_steps = copy.deepcopy(BaseUnitTask.lifecycle_steps)
    lifecycle_steps.update({
        'test': 'npm run ci:unit:client',
    })

    def generate_report(self):
        with self.profiler.actions.generate_report('Moving report for tests'):
            shutil.move('{}/results'.format(self.project_dir), str(self.path('results')))
