# -*- coding: utf-8 -*-

import copy
from sandbox.projects.sandbox_ci.task import BaseUnitTask


class SandboxCiFijiUnitSpec(BaseUnitTask):
    """
    Тесты на react-компоненты(spec) Картинок и Видео (mm-interfaces/fiji)
    """

    project_name = 'fiji'

    spec_report_dir = 'spec-report'
    spec_report_file = 'report.html'

    unit_type = 'spec'
    reports = {
        '{}/{}'.format(project_name, spec_report_dir): spec_report_file
    }

    lifecycle_steps = copy.deepcopy(BaseUnitTask.lifecycle_steps)
    lifecycle_steps.update({
        'prepare': 'mkdir {spec_report_dir}',
        'test': 'bin/fiji spec --reporter html --reporter-options output={spec_report_dir}/{spec_report_file}'
    })

    @property
    def lifecycle(self):
        return super(SandboxCiFijiUnitSpec, self).lifecycle.update_vars(
            spec_report_dir=self.spec_report_dir,
            spec_report_file=self.spec_report_file,
        )

    def prepare_sources(self):
        super(SandboxCiFijiUnitSpec, self).prepare_sources()
        with self.profiler.actions.config('Creating directory for html report'):
            self.lifecycle('prepare')
