# -*- coding: utf-8 -*-

import copy
from sandbox.projects.sandbox_ci.task import BaseUnitTask


class SandboxCiFijiUnitTmpl(BaseUnitTask):
    """
    Тесты на шаблоны(tmpl) Картинок и Видео (mm-interfaces/fiji)
    """

    project_name = 'fiji'

    unit_type = 'tmpl'
    reports = {
        'fiji/tmpl-specs-reports': 'report.html'
    }

    lifecycle_steps = copy.deepcopy(BaseUnitTask.lifecycle_steps)
    lifecycle_steps.update({
        'test': 'bin/fiji tmpl --reporter=spec,html',
        'config': 'bin/fiji config testing',
    })

    def prepare_sources(self):
        super(SandboxCiFijiUnitTmpl, self).prepare_sources()
        with self.profiler.actions.config('Creating link to config'):
            self.lifecycle('config')
