# -*- coding: utf-8 -*-

import os
from sandbox import sdk2
from sandbox.common.types import task as ctt

from sandbox.projects.sandbox_ci.task import BaseHermioneCommonTask


class SandboxCiHermioneE2E(BaseHermioneCommonTask):
    tool = 'hermione-e2e'

    name = 'SANDBOX_CI_HERMIONE_E2E'

    class Requirements(BaseHermioneCommonTask.Requirements):
        cores = 4
        ram = 16384

        semaphores = ctt.Semaphores(
            acquires=[ctt.Semaphores.Acquire(name='hermione_e2e', weight=1)],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH, ctt.Status.Group.WAIT, ctt.Status.FINISHING)
        )

        class Caches(BaseHermioneCommonTask.Requirements.Caches):
            pass

    class Parameters(BaseHermioneCommonTask.Parameters):
        hermione_base_url = sdk2.parameters.String('Hermione base url')
        project_name = sdk2.parameters.String('Project name', required=True)

    def set_environments(self):
        super(SandboxCiHermioneE2E, self).set_environments()

        os.environ['hermione_base_url'] = self.Parameters.hermione_base_url

        # TODO: сделать лучше в https://st.yandex-team.ru/FEI-17639
        if self.Parameters.wait_output_parameters:
            os.environ['hermione_beta_slot'] = self.task_dependencies.get_output_parameter('beta_slot')

    @property
    def run_opts(self):
        return '--config .hermione-e2e.conf.js {}'.format(super(SandboxCiHermioneE2E, self).run_opts)

    @property
    def project_name(self):
        return str(self.Parameters.project_name)

    @classmethod
    def format_github_context(cls, description):
        return u'[Sandbox CI] {}: {}'.format(cls.tool.capitalize(), description)

    def on_save(self):
        super(SandboxCiHermioneE2E, self).on_save()

        if self.use_git_in_overlayfs_mode:
            self.set_ramdrive_size(25 * 1024)
