# -*- coding: utf-8 -*-

from sandbox.projects.resource_types import REPORT_TEMPLATES_PACKAGE
from sandbox.projects.sandbox_ci.task import BaseMetaTask


class SandboxCiJsonproxy(BaseMetaTask):
    """
    Австосборка ручек для старых приложений (serp/jsonproxy)
    """
    project_name = 'jsonproxy'

    lifecycle_steps = {
        'npm_install': 'npm ci',
        'build': 'npm run build',
        'artifacts': 'npm run artifacts'
    }

    lifecycle_artifacts_map = {
        'artifacts': ['jsonproxy-templates'],
    }

    artifacts_resource_types = {
        'jsonproxy-templates': REPORT_TEMPLATES_PACKAGE,
    }

    github_context = u'[Sandbox CI] Автосборка'
