# -*- coding: utf-8 -*-

from sandbox.common.errors import TaskFailure
from sandbox.common.utils import singleton_property, classproperty
from sandbox.common.types import task as ctt
from copy import deepcopy

from sandbox.projects.sandbox_ci.utils import env
from sandbox.projects.sandbox_ci.sandbox_ci_palmsync.SandboxCiPalmsyncBaseTask import SandboxCiPalmsyncBaseTask
from sandbox.projects.sandbox_ci.managers.actions_constants import actions_constants


class SandboxCiPalmsyncValidate(SandboxCiPalmsyncBaseTask):
    tool = 'palmsync_validate'
    lifecycle_steps = deepcopy(SandboxCiPalmsyncBaseTask.lifecycle_steps)
    lifecycle_steps.update({
        'test': 'node --max-old-space-size=4096 $(npm bin)/palmsync validate {run_custom_opts}'
    })

    @singleton_property
    def cache_parameters(self):
        parameters = super(SandboxCiPalmsyncValidate, self).cache_parameters
        parameters.update(
            # получаем список из id артефактов
            build_artifacts_resources=map(int, self.Parameters.build_artifacts_resources)
        )
        return parameters

    @classproperty
    def github_context(self):
        return u'[Sandbox CI] Валидация тестовых сценариев'

    def get_conf_environ(self):
        return env.merge((
            super(SandboxCiPalmsyncValidate, self).get_conf_environ(),
            self.config.get_deep_value(['tests', 'environ'], {}),
            self.config.get_deep_value(['tests', self.tool, 'environ'], {})
        ))

    def test(self):
        # run palmsync validate
        with self.profile_action(actions_constants['TEST'], 'Running palmsync validate'):
            process = self.lifecycle('test', wait=False)
            is_failed = bool(process.wait())
            report_status = ctt.Status.FAILURE if is_failed else ctt.Status.SUCCESS

            self.make_reports(report_status)

            if is_failed:
                raise TaskFailure('palmsync validate error, check report test.out.txt')

    def make_reports(self, status):
        self.artifacts.create_report(
            resource_path=self.artifacts.duplicate_artifact_from_task_log('test.out.txt'),
            type='test.out.txt',
            add_to_context=True,
            status=status,
            public=True,
        )

        super(SandboxCiPalmsyncValidate, self).make_reports()
