# -*- coding: utf-8 -*-

import json

from sandbox import sdk2

from sandbox.common.errors import TaskFailure

from sandbox.projects.sandbox_ci.sandbox_ci_web4_experiments.task import SandboxCiWeb4Experiments
from sandbox.projects.sandbox_ci.task.experiments import BaseExperimentsReleaseRunnerTask

from sandbox.projects.sandbox_ci.sandbox_ci_hermione import SandboxCiHermione


class SandboxCiWeb4ExperimentsReleaseRunner(BaseExperimentsReleaseRunnerTask):
    """
    Запуск релизных hermione тестов web4 с экспериментальными флагами
    """
    name = 'SANDBOX_CI_WEB4_EXPERIMENTS_RELEASE_RUNNER'
    project_task_type = 'SANDBOX_CI_WEB4'
    experiments_subtask_type = SandboxCiWeb4Experiments

    allowed_handlers = ['REPORT', 'WEB']

    def _get_report_ids(self):
        experiments_task = self.get_project_experiments_task()
        report_ids = []
        for tool in self.Parameters.tools:
            task_type = self._get_task_type(tool)
            report_type = self._get_report_type(tool)

            tests = experiments_task.find(task_type)
            for test in tests:
                report = self._find_report(test, report_type)
                if report:
                    report_ids.append(report.id)
                elif task_type == SandboxCiHermione:  # выгасить этот костыль после https://st.yandex-team.ru/FEI-6887
                    for subtask_id in test.Context.subtasks:
                        report = self._find_report(self._find_task_by_id(subtask_id), report_type)
                        if report:
                            report_ids.append(report.id)

        return report_ids

    def run_project_experiments_task(self, templates_task, tests_task, **params):
        self.check_tasks_compatibility(templates_task, tests_task)

        return super(SandboxCiWeb4ExperimentsReleaseRunner, self).run_project_experiments_task(
            templates_task,
            tests_task,

            project_hash_for_tests=tests_task.Parameters.project_hash,
            use_overlayfs=templates_task.Parameters.use_overlayfs and tests_task.Parameters.use_overlayfs,

            **params
        )

    def check_tasks_compatibility(self, templates_task, tests_task):
        def has_different_modes(task_1, task_2):
            return task_1.Parameters.use_overlayfs != task_2.Parameters.use_overlayfs

        def is_legacy_mode(task_1, task_2):
            return not task_1.Parameters.use_overlayfs and not task_2.Parameters.use_overlayfs

        def has_different_project_tree_hashes(task_1, task_2):
            return task_1.Parameters.project_tree_hash != task_2.Parameters.project_tree_hash

        if has_different_modes(templates_task, tests_task) or (is_legacy_mode(templates_task, tests_task) and has_different_project_tree_hashes(templates_task, tests_task)):
            raise TaskFailure("""
                Нельзя выбирать шаблоны из релиза, а тесты из dev
                Подробности в https://st.yandex-team.ru/FEI-16283
            """)
