# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.common.types.client import Tag
from sandbox.projects.sandbox_ci.sandbox_ci_web4 import SandboxCiWeb4


class SandboxCiWeb4MultlislotBuild(SandboxCiWeb4):
    class Requirements(SandboxCiWeb4.Requirements):
        class Caches(SandboxCiWeb4.Requirements.Caches):
            pass

    def on_enqueue(self):
        super(SandboxCiWeb4, self).on_enqueue()

        if not getattr(self.Context, 'copy_of', False):
            processors = map(lambda i: getattr(Tag, i), filter(bool, map(lambda i: i.strip(), self.config.get_deep_value(['build', 'processors'], '').split(','))))
            if processors:
                self.Requirements.client_tags &= (reduce(lambda x, y: x | y, processors))

