# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.sandbox_ci.sandbox_ci_web4 import SandboxCiWeb4
from sandbox.projects.sandbox_ci.sandbox_ci_dummy_hermione import SandboxCiDummyHermione


class SandboxCiWeb4Priemka(SandboxCiWeb4):
    u"""Приемочная таска для Sandbox (serp/web4)"""

    name = 'SANDBOX_CI_WEB4_PRIEMKA'

    class Parameters(SandboxCiWeb4.Parameters):
        with sdk2.parameters.Group('Subtasks') as custom_options:
            hermione_custom_opts = sdk2.parameters.String(
                'Дополнительные ключи при запуске hermione',
                default='--grep foo',
            )
            hermione_e2e_custom_opts = sdk2.parameters.String(
                'Дополнительные ключи при запуске hermione на реальных данных',
                default='--grep foo',
            )
            palmsync_validate_custom_opts = sdk2.parameters.String(
                'Дополнительные ключи при запуске palmsync validate',
                default='--skip scenarios --skip tests',
            )
            palmsync_synchronize_custom_opts = sdk2.parameters.String(
                'Дополнительные ключи при запуске palmsync synchronize',
                default='--dry',
            )
            statface_host = sdk2.parameters.String(
                'Statface Host',
                default='upload.stat-beta.yandex-team.ru',
            )

    # FEI-21975
    def on_save(self):
        super(SandboxCiWeb4Priemka, self).on_save()

        if not self.Parameters.external_config:
            self.Parameters.external_config = {
                'dev.stat.actions_profile': False,
            }

    def on_create(self):
        super(SandboxCiWeb4Priemka, self).on_create()

    def create_hermione_subtask(self, wait_tasks=None, **params):
        return super(SandboxCiWeb4Priemka, self).create_hermione_subtask(
            wait_tasks=wait_tasks,
            custom_opts=self.Parameters.hermione_custom_opts,
            task_type=SandboxCiDummyHermione,
            **params
        )

    def create_hermione_e2e_subtask(self, wait_tasks=None, **params):
        return super(SandboxCiWeb4Priemka, self).create_hermione_e2e_subtask(
            wait_tasks=wait_tasks,
            custom_opts=self.Parameters.hermione_custom_opts,
            use_synchrophazotron=False,
            **params
        )

    def create_hermione_task(self, **params):
        return None

    def create_deploy_ugc_subtask(self, *args, **params):
        return None

    def create_palmsync_validate_subtask(self, **params):
        return None

    def create_palmsync_subtask(self, wait_tasks, **params):
        return None

    def create_palmsync_synchronize_subtask(self):
        return None

    def create_linters_subtask(self, wait_tasks=None):
        return None

    def create_docs_subtask(self, wait_tasks=None):
        return None

    def create_pulse_subtasks(self, *args, **params):
        return []

    def create_deploy_yappy_subtask(self, *args, **params):
        return None

    def create_yappy_cleanup_subtask(self, *args, **params):
        return None

    def create_test_changes_collector_subtask(self):
        return None

    def create_assert_metrics_stats_subtask(self, wait_tasks=None):
        return None
