# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.sandbox_ci.sandbox_ci_web4 import SandboxCiWeb4
from sandbox.projects.sandbox_ci.sandbox_ci_web4_experiments.task import SandboxCiWeb4Experiments
from sandbox.projects.sandbox_ci.task import BasePullRequestRunnerTask


class SandboxCiWeb4PullRequestRunner(BasePullRequestRunnerTask):
    """Запуск проверок web4 из ПР с флагами"""
    name = 'SANDBOX_CI_WEB4_PULL_REQUEST_RUNNER'

    class Parameters(BasePullRequestRunnerTask.Parameters):
        tools = sdk2.parameters.CheckGroup(
            'Tools',
            choices=(
                ('Hermione', 'hermione'),
                ('Hermione e2e', 'hermione-e2e'),
                ('Pulse Shooter Custom', 'pulse-shooter'),
            ),
            default=['hermione', 'hermione-e2e'],
            required=True,
        )
        platforms = sdk2.parameters.CheckGroup(
            'Platforms',
            choices=(
                ('desktop', 'desktop'),
                ('touch-pad', 'touch-pad'),
                ('touch-phone', 'touch-phone'),
            ),
            default=['desktop', 'touch-pad', 'touch-phone'],
            required=True,
        )

    project_name = 'web4'
    build_task_type = SandboxCiWeb4
    experiments_subtask_type = SandboxCiWeb4Experiments

    def get_params_for_tool(self, tool):
        if tool == 'pulse-shooter':
            return dict(
                pulse_shooter_query_params=['no-tests=1'] + self._convert_flags_to_query_list(self.formatted_flags)
            )

        return super(SandboxCiWeb4PullRequestRunner, self).get_params_for_tool(tool)

    def _convert_flags_to_query_list(self, flags):
        return map(lambda flag: 'exp_flags={}'.format(flag), flags)

    def create_experiments_subtask(self, build_task, **custom_task_params):
        return super(SandboxCiWeb4PullRequestRunner, self).create_experiments_subtask(
            build_task,

            project_hash_for_tests=build_task.Parameters.project_hash,
            use_overlayfs=build_task.Parameters.use_overlayfs,

            **custom_task_params
        )
