# coding=utf-8
import logging

from sandbox import sdk2

import sandbox.common.types.misc as ctm
from sandbox.common.types.client import Tag
from sandbox.common.types import task as ctt
from sandbox.common.utils import singleton
from sandbox.projects.sandbox_ci import parameters
from sandbox.projects.sandbox_ci.task import BaseBuildTask

import sys
reload(sys)
sys.setdefaultencoding('utf8')


class BaseMetaTask(BaseBuildTask):
    class Parameters(BaseBuildTask.Parameters):
        fail_on_any_error = True
        blockstat_tests = sdk2.parameters.Bool(
            'Blockstat Tests',
            description=u'Включает тесты для счетчиков blockstat',
            default=False,
        )
        draft_mode = sdk2.parameters.Bool(
            'Draft mode',
            description=u'Создавать, но не запускать тесты',
            default=False,
        )
        pr_description_config_path = sdk2.parameters.String(
            'PR description config path',
            description=u'Путь к файлу конфигурации описания пулл-реквеста (относительно корня проекта)',
            default='.config/pr-description.json'
        )
        with sdk2.parameters.Group('Pulse') as pulse_block:
            predict_ammo_counter = sdk2.parameters.Bool(
                'Вычислить счётчик затронутой фичи',
                description=u'Попробовать угадать счётчик затронутой фичи для запуска PULSE_SHOOTER_CUSTOM',
                default=False
            )

        with sdk2.parameters.Output():
            with sdk2.parameters.Group('Tracker') as tracker_output_block:
                send_comment_to_issue = parameters.send_comment_to_issue()

            with sdk2.parameters.Group('Pulse') as pulse_output_block:
                ammo_counters = sdk2.parameters.JSON(
                    'Счётчики фичи',
                    description=(
                        'Счётчики затронутой фичи для запуска PULSE_SHOOTER_CUSTOM\n'
                        '(в формате {"touch-phone": "/$page/$main/$result/#type:wizard/#wizard_name:images", "desktop": "/$page/$parallel/$result/#type:wizard/#wizard_name:images"})'
                    )
                )

    class Context(BaseBuildTask.Context):
        skipped_steps = []

    class Requirements(BaseBuildTask.Requirements):
        class Caches(BaseBuildTask.Requirements.Caches):
            pass

    def create_blockstat_test_subtask(self, task_type, platform, templates, **params):
        return self.meta.create_subtask(
            task_type=task_type,
            description=self.Parameters.description,
            project_name=self.project_name,
            platform=platform,
            templates=templates,
            ref=self.Parameters.project_git_base_ref,
            waitable=bool(self.config.get_deep_value(['tests', 'blockstat', 'waitable'], True)),
            **params
        )

    @property
    def sub_project(self):
        return None

    def need_to_skip_check(self, label):
        """
        Проверяет нужно ли пропустить указанную проверку

        :rtype: bool
        """
        return label in self.checks_to_skip

    def on_enqueue(self):
        super(BaseMetaTask, self).on_enqueue()

        self.__set_cores_requirement()

        # костыль по мотивам INFRADUTY-11685 (оторвать после FEI-19392)
        is_production_sandbox = self.registry.common.installation == ctm.Installation.PRODUCTION

        if is_production_sandbox:
            self.__set_processors_requirement()

        self.__set_semaphores_requirement()

    def __set_cores_requirement(self):
        try:
            with self.memoize_stage.cores:
                cores = self.config.get_deep_value(['build', 'cores'], None)
                if cores:
                    self.Requirements.cores = cores
        except Exception as e:
            logging.exception('Error on setting cores: {}'.format(e))

    def __set_processors_requirement(self):
        with self.memoize_stage.processors:
            if not getattr(self.Context, 'copy_of', False):
                processors = map(lambda i: getattr(Tag, i), filter(bool, map(lambda i: i.strip(), self.config.get_deep_value(['build', 'processors'], '').split(','))))
                if processors:
                    self.Requirements.client_tags &= (reduce(lambda x, y: x | y, processors))

    def __set_semaphores_requirement(self):
        if not self.is_mq_cache_semaphore_required():
            return

        # @TODO: заменить на 'self.Requirements.semaphores = None' после https://st.yandex-team.ru/SANDBOX-5938
        self.set_semaphore(name=self.infra_infinity_semaphore)

        with self.memoize_stage.semaphores:
            if not self.__has_mq_cache_semaphore():
                return

            self.set_semaphore(name=self.__get_mq_cache_semaphore_name())

    def __is_mq_cache_task(self):
        tags = map(lambda tag: tag.lower(), self.Parameters.tags)

        return 'mq' in tags and ('cache' in tags or 'recache' in tags)

    def __has_mq_cache_semaphore(self):
        return self.__has_semaphore(self.__get_mq_cache_semaphore_name())

    def __get_mq_cache_semaphore_name(self):
        return 'mq_cache_{owner}_{repo}'.format(owner=self.Parameters.project_github_owner, repo=self.Parameters.project_github_repo)

    def __has_semaphore(self, name):
        semaphores = self.server.semaphore.read(name=name, limit=-1)['items']

        return name in map(lambda s: s['name'], semaphores)

    def is_mq_cache_semaphore_required(self):
        return self.__is_mq_cache_task()

    @staticmethod
    def is_test_task(task):
        from sandbox.projects.sandbox_ci.sandbox_ci_blockstat_test import SandboxCiBlockstatTest
        from sandbox.projects.sandbox_ci.sandbox_ci_hermione_e2e import SandboxCiHermioneE2E
        from sandbox.projects.sandbox_ci.sandbox_ci_palmsync.validate import SandboxCiPalmsyncValidate
        from sandbox.projects.sandbox_ci.task import BaseLintersTask, BasePulseTask, BaseUnitTask
        from sandbox.projects.sandbox_ci.task.skip_validator import SandboxCiSkipValidator
        from sandbox.projects.sandbox_ci.task.test_task.BaseTestTask import BaseTestTask
        from sandbox.projects.sandbox_ci.task.test_task.HermioneTask import HermioneTask

        return isinstance(task, (BaseTestTask, HermioneTask, BaseLintersTask, SandboxCiPalmsyncValidate, BaseUnitTask,
                                 SandboxCiSkipValidator, SandboxCiHermioneE2E, SandboxCiBlockstatTest,
                                 BasePulseTask))

    def start_declared_subtasks(self, created_subtasks):
        tasks = created_subtasks
        if self.Parameters.draft_mode:
            logging.debug('Draft mode is on, not starting test subtasks')
            tasks = filter(lambda t: not self.is_test_task(t), tasks)
        return super(BaseMetaTask, self).start_declared_subtasks(tasks)

    def on_execute(self):
        with self.memoize_stage.update_and_comment_searel_issue:
            if self.Parameters.is_release:
                self.log_build_created_release_step()
                self.update_and_comment_searel_issue()

        super(BaseMetaTask, self).on_execute()

    def update_and_comment_searel_issue(self):
        issue_key = self.get_searel_issue_key_by_ref()

        if not issue_key:
            return

        if self.Parameters.send_comment_to_searel:
            self.Parameters.send_comment_to_issue = issue_key
            self.release.add_task_commencement_comment(issue_key)

        self.release.add_task_remotelink(issue_key)
        self.release.add_issue_link_to_info(issue_key)

    def log_build_created_release_step(self):
        try:
            issue_key = self.get_searel_issue_key_by_ref()

            if not issue_key:
                return

            self.metrics_logger.log_release_steps([dict(
                project='{}/{}'.format(self.Parameters.project_github_owner, self.Parameters.project_github_repo),
                version=self.release_version,
                issue=issue_key,
                step='build_created',
            )])
        except Exception:
            logging.exception('Exception while logging release step')

    @singleton
    def get_searel_issue_key_by_ref(self):
        repo = self.Parameters.project_github_repo
        owner = self.Parameters.project_github_owner
        ref = self.ref

        summary = '{owner}/{repo}@{version}'.format(
            repo=repo,
            owner=owner,
            version=self.release_version,
        )

        if ref.startswith('releases/frontend/'):
            summary=ref

        return self.release.get_searel_issue_key_by_summary_safe(summary=summary)

    def acquire_dev_build_semaphore(self, prefix='dev'):
        name = prefix + '_build_' + self.project_name
        self.Requirements.semaphores = ctt.Semaphores(
            acquires=[ctt.Semaphores.Acquire(name=name, weight=1)],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH),
        )
