# -*- coding: utf-8 -*-

from sandbox.common.utils import singleton_property

from sandbox.projects.sandbox_ci import managers


class ManagersTaskMixin(object):
    @singleton_property
    def artifacts(self):
        return managers.ArtifactsManager(self)

    @singleton_property
    def dependencies(self):
        return managers.DependenciesManager(self, self.project_name)

    @singleton_property
    def scripts(self):
        return managers.ScriptsManager(self, 'scripts')

    @singleton_property
    def cache_profiler(self):
        return managers.CacheProfilerManager(self)

    @singleton_property
    def profiler(self):
        return managers.ProfilerManager(self)

    @singleton_property
    def deep_actions_profiler(self):
        return managers.DeepActionsProfiler(self)

    @singleton_property
    def task_reports(self):
        return managers.Reports(self)

    @singleton_property
    def github_statuses(self):
        return managers.GitHubStatusesManager(self)

    @singleton_property
    def arcanum_checks(self):
        return managers.ArcanumStatusesManager(self)

    @singleton_property
    def scp_feedback(self):
        return managers.SourceCodeProviderFeedback(self)

    @singleton_property
    def lifecycle(self):
        lifecycle_steps = self.lifecycle_steps if hasattr(self, 'lifecycle_steps') else {}
        default_work_dir = self.project_dir if hasattr(self, 'project_dir') else self.path()
        return managers.LifecycleManager(self, lifecycle_steps, default_work_dir)

    @singleton_property
    def meta(self):
        return managers.MetaTaskManager(self)

    @singleton_property
    def task_dependencies(self):
        return managers.TaskDependenciesManager(self)

    @singleton_property
    def config(self):
        return managers.ConfigManager(self)

    @singleton_property
    def statface(self):
        return managers.StatfaceManager(self)

    @singleton_property
    def startrek(self):
        return managers.StartrekManager(self)

    @singleton_property
    def vault(self):
        return managers.VaultManager(self)

    @singleton_property
    def checks_to_skip(self):
        return managers.SelectiveChecks(self).checks_to_skip()

    @singleton_property
    def info(self):
        return managers.InfoManager(self)

    @singleton_property
    def webhook(self):
        return managers.WebHookManager(self)

    @singleton_property
    def release(self):
        return managers.ReleaseManager(self)

    @singleton_property
    def selective(self):
        return managers.SelectiveManager(self)

    @singleton_property
    def selective_coverage(self):
        return managers.SelectiveCoverageManager(self)

    @singleton_property
    def stability_index(self):
        return managers.StabilityIndexManager(self)

    @singleton_property
    def html_report(self):
        return managers.HtmlReportManager(self)

    @singleton_property
    def plugins_profiler_report(self):
        return managers.PluginsProfilerReportManager(self)

    @singleton_property
    def json_report(self):
        return managers.JsonReportManager(self)

    @singleton_property
    def mq_manager(self):
        return managers.MergeQueueManager(self)

    @singleton_property
    def assert_metrics(self):
        return managers.AssertMetricsManager(self)

    @singleton_property
    def browsers_config(self):
        return managers.BrowsersConfigManager(self)

    @singleton_property
    def stat_report(self):
        return managers.StatReportManager(self)

    @singleton_property
    def tags_manager(self):
        return managers.TagsManager(self)

    @singleton_property
    def metrics_logger(self):
        return managers.MetricsLogger()

    @singleton_property
    def zeroline_reporter(self):
        return managers.ZerolineReporter()

    @singleton_property
    def skip_list(self):
        return managers.SkipListManager(self)

    @singleton_property
    def template_errors(self):
        return managers.TemplateErrorCollectorManager(self)
