# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.utils.context import Overlayfs
from sandbox.projects.sandbox_ci.utils.list_utils import flatten


class OverlayfsMixin(object):
    def _overlayfs(self, lower_dirs, target_dir, resources=None):
        if resources is not None:
            lower_dirs += flatten(self._download_sources(resources=resources, target_dir=target_dir))

        with Overlayfs(lower_dirs=lower_dirs, mount_point_symlink=target_dir):
            lower_dirs += flatten(self._install_dependencies())

        return Overlayfs(lower_dirs=lower_dirs, mount_point_symlink=target_dir)

    def _download_sources(self, resources, target_dir):
        raise Exception('"_download_sources" should be specified in descendants of "OverlayfsMixin"')

    def _install_dependencies(self):
        raise Exception('"_install_dependencies" should be specified in descendants of "OverlayfsMixin"')
