# -*- coding: utf-8 -*-

from sandbox.sdk2.vcs.git import Git
from sandbox.common.utils import singleton_property
from sandbox.projects.sandbox_ci.utils.git import git_cache


class ProjectPathsMixin(object):
    @singleton_property
    def project_dir(self):
        return self.working_path(self.Parameters.project_github_repo)

    def working_path(self, *args):
        if self.ramdrive and self.ramdrive.path:
            return self.ramdrive_path(*args)
        return self.path(*args)

    def ramdrive_path(self, *args):
        if self.ramdrive and self.ramdrive.path:
            return self.ramdrive.path.joinpath(*args) if args else self.ramdrive.path
        raise Exception('RamDrive is not configured for task')

    @singleton_property
    def arc_mount_path(self):
        return self.working_path('arc_mount')

    @singleton_property
    def arc_object_store_path(self):
        return self.working_path('arc_object_store')

    @singleton_property
    def arc_store_path(self):
        return self.working_path('arc_store')

    @singleton_property
    def arc_project_dir(self):
        return self.arc_mount_path / 'frontend' / 'projects' / self.project_name

    @singleton_property
    def project_sources_dir(self):
        if getattr(self, 'use_arc', False):
            return self.arc_project_dir

        return self.working_path('sources')

    @singleton_property
    def project_git_dir(self):
        # без str упадёт внутри модуля git
        return str(self.project_dir)

    @singleton_property
    def project_git(self):
        return Git(self.Context.project_git_url)

    def project_git_exec(self, *args):
        git_process = self.project_git.raw_execute(args, cwd=self.project_git_dir)

        return git_process.communicate()[0].strip()

    @singleton_property
    def project_git_cache_dir(self):
        return git_cache(self.Context.project_git_url)
