# -*- coding: utf-8 -*-

import os

from sandbox.common.utils import singleton_property


class SelectiveMixin(object):
    @singleton_property
    def cache_parameters(self):
        parameters = super(SelectiveMixin, self).cache_parameters

        # Селективные тесты могут реиспользовать и селективные, и полные тесты.
        # Полные тесты могут реиспользовать только полные.
        if self.Parameters.selective_run is False:
            parameters.update(selective_run=False)

        return parameters

    def set_environments(self):
        super(SelectiveMixin, self).set_environments()

        os.environ['selective_enabled'] = 'true'
        os.environ['selective_log_path'] = self.selective.index_file_name
        os.environ['selective_changed_files_path'] = self.Parameters.changed_files

    def _get_reports_attrs(self, status):
        attrs = {
            'tool': self.tool,
        }
        if hasattr(self.Parameters, 'platform'):
            attrs['platform'] = self.Parameters.platform

        return super(SelectiveMixin, self)._get_reports_attrs(status) + self.selective.get_reports_attrs(**attrs)
